<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddRateGroupResponse StructType
 * @subpackage Structs
 */
class AddRateGroupResponse extends AbstractStructBase
{
    /**
     * The i_rate_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - arrayType: int[]
     * - ref: soapenc:arrayType
     * @var int[]
     */
    public $i_rate_list;
    /**
     * Constructor method for AddRateGroupResponse
     * @uses AddRateGroupResponse::setI_rate_list()
     * @param int[] $i_rate_list
     */
    public function __construct(array $i_rate_list = array())
    {
        $this
            ->setI_rate_list($i_rate_list);
    }
    /**
     * Get i_rate_list value
     * @return int[]
     */
    public function getI_rate_list()
    {
        return $this->i_rate_list;
    }
    /**
     * Set i_rate_list value
     * @throws \InvalidArgumentException
     * @param int[] $i_rate_list
     * @return \StructType\AddRateGroupResponse
     */
    public function setI_rate_list(array $i_rate_list = array())
    {
        foreach ($i_rate_list as $addRateGroupResponseI_rate_listItem) {
            // validation for constraint: itemType
            if (!is_numeric($addRateGroupResponseI_rate_listItem)) {
                throw new \InvalidArgumentException(sprintf('The i_rate_list property can only contain items of int, "%s" given', is_object($addRateGroupResponseI_rate_listItem) ? get_class($addRateGroupResponseI_rate_listItem) : gettype($addRateGroupResponseI_rate_listItem)), __LINE__);
            }
        }
        $this->i_rate_list = $i_rate_list;
        return $this;
    }
    /**
     * Add item to i_rate_list value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\AddRateGroupResponse
     */
    public function addToI_rate_list($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The i_rate_list property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->i_rate_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddRateGroupResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
