<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddCurrencyResponse StructType
 * @subpackage Structs
 */
class AddCurrencyResponse extends AbstractStructBase
{
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $iso_4217;
    /**
     * The i_ma_currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_ma_currency;
    /**
     * Constructor method for AddCurrencyResponse
     * @uses AddCurrencyResponse::setIso_4217()
     * @uses AddCurrencyResponse::setI_ma_currency()
     * @param string $iso_4217
     * @param int $i_ma_currency
     */
    public function __construct($iso_4217 = null, $i_ma_currency = null)
    {
        $this
            ->setIso_4217($iso_4217)
            ->setI_ma_currency($i_ma_currency);
    }
    /**
     * Get iso_4217 value
     * @return string
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\AddCurrencyResponse
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Get i_ma_currency value
     * @return int|null
     */
    public function getI_ma_currency()
    {
        return $this->i_ma_currency;
    }
    /**
     * Set i_ma_currency value
     * @param int $i_ma_currency
     * @return \StructType\AddCurrencyResponse
     */
    public function setI_ma_currency($i_ma_currency = null)
    {
        // validation for constraint: int
        if (!is_null($i_ma_currency) && !is_numeric($i_ma_currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_ma_currency)), __LINE__);
        }
        $this->i_ma_currency = $i_ma_currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddCurrencyResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
