<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDRInfo StructType
 * @subpackage Structs
 */
class XDRInfo extends AbstractStructBase
{
    /**
     * The i_xdr
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_xdr;
    /**
     * The i_service
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_service;
    /**
     * The CLI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CLI;
    /**
     * The CLD
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CLD;
    /**
     * The charged_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $charged_amount;
    /**
     * The charged_quantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $charged_quantity;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The subdivision
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subdivision;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The disconnect_cause
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $disconnect_cause;
    /**
     * The bill_status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bill_status;
    /**
     * The disconnect_reason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $disconnect_reason;
    /**
     * The connect_time
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $connect_time;
    /**
     * The unix_connect_time
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $unix_connect_time;
    /**
     * The disconnect_time
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $disconnect_time;
    /**
     * The unix_disconnect_time
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $unix_disconnect_time;
    /**
     * The bill_time
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bill_time;
    /**
     * The bit_flags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $bit_flags;
    /**
     * The call_recording_url
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $call_recording_url;
    /**
     * The call_recording_server_url
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $call_recording_server_url;
    /**
     * Constructor method for XDRInfo
     * @uses XDRInfo::setI_xdr()
     * @uses XDRInfo::setI_service()
     * @uses XDRInfo::setCLI()
     * @uses XDRInfo::setCLD()
     * @uses XDRInfo::setCharged_amount()
     * @uses XDRInfo::setCharged_quantity()
     * @uses XDRInfo::setCountry()
     * @uses XDRInfo::setSubdivision()
     * @uses XDRInfo::setDescription()
     * @uses XDRInfo::setDisconnect_cause()
     * @uses XDRInfo::setBill_status()
     * @uses XDRInfo::setDisconnect_reason()
     * @uses XDRInfo::setConnect_time()
     * @uses XDRInfo::setUnix_connect_time()
     * @uses XDRInfo::setDisconnect_time()
     * @uses XDRInfo::setUnix_disconnect_time()
     * @uses XDRInfo::setBill_time()
     * @uses XDRInfo::setBit_flags()
     * @uses XDRInfo::setCall_recording_url()
     * @uses XDRInfo::setCall_recording_server_url()
     * @param int $i_xdr
     * @param int $i_service
     * @param string $cLI
     * @param string $cLD
     * @param float $charged_amount
     * @param int $charged_quantity
     * @param string $country
     * @param string $subdivision
     * @param string $description
     * @param string $disconnect_cause
     * @param string $bill_status
     * @param string $disconnect_reason
     * @param string $connect_time
     * @param int $unix_connect_time
     * @param string $disconnect_time
     * @param int $unix_disconnect_time
     * @param string $bill_time
     * @param int $bit_flags
     * @param string $call_recording_url
     * @param string $call_recording_server_url
     */
    public function __construct($i_xdr = null, $i_service = null, $cLI = null, $cLD = null, $charged_amount = null, $charged_quantity = null, $country = null, $subdivision = null, $description = null, $disconnect_cause = null, $bill_status = null, $disconnect_reason = null, $connect_time = null, $unix_connect_time = null, $disconnect_time = null, $unix_disconnect_time = null, $bill_time = null, $bit_flags = null, $call_recording_url = null, $call_recording_server_url = null)
    {
        $this
            ->setI_xdr($i_xdr)
            ->setI_service($i_service)
            ->setCLI($cLI)
            ->setCLD($cLD)
            ->setCharged_amount($charged_amount)
            ->setCharged_quantity($charged_quantity)
            ->setCountry($country)
            ->setSubdivision($subdivision)
            ->setDescription($description)
            ->setDisconnect_cause($disconnect_cause)
            ->setBill_status($bill_status)
            ->setDisconnect_reason($disconnect_reason)
            ->setConnect_time($connect_time)
            ->setUnix_connect_time($unix_connect_time)
            ->setDisconnect_time($disconnect_time)
            ->setUnix_disconnect_time($unix_disconnect_time)
            ->setBill_time($bill_time)
            ->setBit_flags($bit_flags)
            ->setCall_recording_url($call_recording_url)
            ->setCall_recording_server_url($call_recording_server_url);
    }
    /**
     * Get i_xdr value
     * @return int|null
     */
    public function getI_xdr()
    {
        return $this->i_xdr;
    }
    /**
     * Set i_xdr value
     * @param int $i_xdr
     * @return \StructType\XDRInfo
     */
    public function setI_xdr($i_xdr = null)
    {
        // validation for constraint: int
        if (!is_null($i_xdr) && !is_numeric($i_xdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_xdr)), __LINE__);
        }
        $this->i_xdr = $i_xdr;
        return $this;
    }
    /**
     * Get i_service value
     * @return int|null
     */
    public function getI_service()
    {
        return $this->i_service;
    }
    /**
     * Set i_service value
     * @param int $i_service
     * @return \StructType\XDRInfo
     */
    public function setI_service($i_service = null)
    {
        // validation for constraint: int
        if (!is_null($i_service) && !is_numeric($i_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service)), __LINE__);
        }
        $this->i_service = $i_service;
        return $this;
    }
    /**
     * Get CLI value
     * @return string|null
     */
    public function getCLI()
    {
        return $this->CLI;
    }
    /**
     * Set CLI value
     * @param string $cLI
     * @return \StructType\XDRInfo
     */
    public function setCLI($cLI = null)
    {
        // validation for constraint: string
        if (!is_null($cLI) && !is_string($cLI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cLI)), __LINE__);
        }
        $this->CLI = $cLI;
        return $this;
    }
    /**
     * Get CLD value
     * @return string|null
     */
    public function getCLD()
    {
        return $this->CLD;
    }
    /**
     * Set CLD value
     * @param string $cLD
     * @return \StructType\XDRInfo
     */
    public function setCLD($cLD = null)
    {
        // validation for constraint: string
        if (!is_null($cLD) && !is_string($cLD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cLD)), __LINE__);
        }
        $this->CLD = $cLD;
        return $this;
    }
    /**
     * Get charged_amount value
     * @return float|null
     */
    public function getCharged_amount()
    {
        return $this->charged_amount;
    }
    /**
     * Set charged_amount value
     * @param float $charged_amount
     * @return \StructType\XDRInfo
     */
    public function setCharged_amount($charged_amount = null)
    {
        $this->charged_amount = $charged_amount;
        return $this;
    }
    /**
     * Get charged_quantity value
     * @return int|null
     */
    public function getCharged_quantity()
    {
        return $this->charged_quantity;
    }
    /**
     * Set charged_quantity value
     * @param int $charged_quantity
     * @return \StructType\XDRInfo
     */
    public function setCharged_quantity($charged_quantity = null)
    {
        // validation for constraint: int
        if (!is_null($charged_quantity) && !is_numeric($charged_quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($charged_quantity)), __LINE__);
        }
        $this->charged_quantity = $charged_quantity;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\XDRInfo
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get subdivision value
     * @return string|null
     */
    public function getSubdivision()
    {
        return $this->subdivision;
    }
    /**
     * Set subdivision value
     * @param string $subdivision
     * @return \StructType\XDRInfo
     */
    public function setSubdivision($subdivision = null)
    {
        // validation for constraint: string
        if (!is_null($subdivision) && !is_string($subdivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subdivision)), __LINE__);
        }
        $this->subdivision = $subdivision;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XDRInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get disconnect_cause value
     * @return string|null
     */
    public function getDisconnect_cause()
    {
        return $this->disconnect_cause;
    }
    /**
     * Set disconnect_cause value
     * @param string $disconnect_cause
     * @return \StructType\XDRInfo
     */
    public function setDisconnect_cause($disconnect_cause = null)
    {
        // validation for constraint: string
        if (!is_null($disconnect_cause) && !is_string($disconnect_cause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($disconnect_cause)), __LINE__);
        }
        $this->disconnect_cause = $disconnect_cause;
        return $this;
    }
    /**
     * Get bill_status value
     * @return string|null
     */
    public function getBill_status()
    {
        return $this->bill_status;
    }
    /**
     * Set bill_status value
     * @param string $bill_status
     * @return \StructType\XDRInfo
     */
    public function setBill_status($bill_status = null)
    {
        // validation for constraint: string
        if (!is_null($bill_status) && !is_string($bill_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bill_status)), __LINE__);
        }
        $this->bill_status = $bill_status;
        return $this;
    }
    /**
     * Get disconnect_reason value
     * @return string|null
     */
    public function getDisconnect_reason()
    {
        return $this->disconnect_reason;
    }
    /**
     * Set disconnect_reason value
     * @param string $disconnect_reason
     * @return \StructType\XDRInfo
     */
    public function setDisconnect_reason($disconnect_reason = null)
    {
        // validation for constraint: string
        if (!is_null($disconnect_reason) && !is_string($disconnect_reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($disconnect_reason)), __LINE__);
        }
        $this->disconnect_reason = $disconnect_reason;
        return $this;
    }
    /**
     * Get connect_time value
     * @return string|null
     */
    public function getConnect_time()
    {
        return $this->connect_time;
    }
    /**
     * Set connect_time value
     * @param string $connect_time
     * @return \StructType\XDRInfo
     */
    public function setConnect_time($connect_time = null)
    {
        // validation for constraint: string
        if (!is_null($connect_time) && !is_string($connect_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connect_time)), __LINE__);
        }
        $this->connect_time = $connect_time;
        return $this;
    }
    /**
     * Get unix_connect_time value
     * @return int|null
     */
    public function getUnix_connect_time()
    {
        return $this->unix_connect_time;
    }
    /**
     * Set unix_connect_time value
     * @param int $unix_connect_time
     * @return \StructType\XDRInfo
     */
    public function setUnix_connect_time($unix_connect_time = null)
    {
        // validation for constraint: int
        if (!is_null($unix_connect_time) && !is_numeric($unix_connect_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unix_connect_time)), __LINE__);
        }
        $this->unix_connect_time = $unix_connect_time;
        return $this;
    }
    /**
     * Get disconnect_time value
     * @return string|null
     */
    public function getDisconnect_time()
    {
        return $this->disconnect_time;
    }
    /**
     * Set disconnect_time value
     * @param string $disconnect_time
     * @return \StructType\XDRInfo
     */
    public function setDisconnect_time($disconnect_time = null)
    {
        // validation for constraint: string
        if (!is_null($disconnect_time) && !is_string($disconnect_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($disconnect_time)), __LINE__);
        }
        $this->disconnect_time = $disconnect_time;
        return $this;
    }
    /**
     * Get unix_disconnect_time value
     * @return int|null
     */
    public function getUnix_disconnect_time()
    {
        return $this->unix_disconnect_time;
    }
    /**
     * Set unix_disconnect_time value
     * @param int $unix_disconnect_time
     * @return \StructType\XDRInfo
     */
    public function setUnix_disconnect_time($unix_disconnect_time = null)
    {
        // validation for constraint: int
        if (!is_null($unix_disconnect_time) && !is_numeric($unix_disconnect_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unix_disconnect_time)), __LINE__);
        }
        $this->unix_disconnect_time = $unix_disconnect_time;
        return $this;
    }
    /**
     * Get bill_time value
     * @return string|null
     */
    public function getBill_time()
    {
        return $this->bill_time;
    }
    /**
     * Set bill_time value
     * @param string $bill_time
     * @return \StructType\XDRInfo
     */
    public function setBill_time($bill_time = null)
    {
        // validation for constraint: string
        if (!is_null($bill_time) && !is_string($bill_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bill_time)), __LINE__);
        }
        $this->bill_time = $bill_time;
        return $this;
    }
    /**
     * Get bit_flags value
     * @return int|null
     */
    public function getBit_flags()
    {
        return $this->bit_flags;
    }
    /**
     * Set bit_flags value
     * @param int $bit_flags
     * @return \StructType\XDRInfo
     */
    public function setBit_flags($bit_flags = null)
    {
        // validation for constraint: int
        if (!is_null($bit_flags) && !is_numeric($bit_flags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bit_flags)), __LINE__);
        }
        $this->bit_flags = $bit_flags;
        return $this;
    }
    /**
     * Get call_recording_url value
     * @return string|null
     */
    public function getCall_recording_url()
    {
        return $this->call_recording_url;
    }
    /**
     * Set call_recording_url value
     * @param string $call_recording_url
     * @return \StructType\XDRInfo
     */
    public function setCall_recording_url($call_recording_url = null)
    {
        // validation for constraint: string
        if (!is_null($call_recording_url) && !is_string($call_recording_url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($call_recording_url)), __LINE__);
        }
        $this->call_recording_url = $call_recording_url;
        return $this;
    }
    /**
     * Get call_recording_server_url value
     * @return string|null
     */
    public function getCall_recording_server_url()
    {
        return $this->call_recording_server_url;
    }
    /**
     * Set call_recording_server_url value
     * @param string $call_recording_server_url
     * @return \StructType\XDRInfo
     */
    public function setCall_recording_server_url($call_recording_server_url = null)
    {
        // validation for constraint: string
        if (!is_null($call_recording_server_url) && !is_string($call_recording_server_url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($call_recording_server_url)), __LINE__);
        }
        $this->call_recording_server_url = $call_recording_server_url;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XDRInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
