<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCRoutingPlanInfo StructType
 * @subpackage Structs
 */
class WCRoutingPlanInfo extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Name of the plan on the PortaBilling100 interface, unique in the environment, mandatory, 32 chars max
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The categories_enabled
     * Meta informations extracted from the WSDL
     * - documentation: Route Categories: Y - enabled, N - disabled
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $categories_enabled;
    /**
     * The override_routes_enabled
     * Meta informations extracted from the WSDL
     * - documentation: Override Routes: Y - enabled, N - disabled
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $override_routes_enabled;
    /**
     * The i_routing_plan
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of the plan
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_routing_plan;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Description of the category, 255 chars max
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The selection_code
     * Meta informations extracted from the WSDL
     * - documentation: Selection Code, 16 latin chars max
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $selection_code;
    /**
     * The i_dest_group_set
     * Meta informations extracted from the WSDL
     * - documentation: ID of the Destination Group Set
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_dest_group_set;
    /**
     * The profit_monitor
     * Meta informations extracted from the WSDL
     * - documentation: Send real-time alerts about calls with losses: Y - yes, N - no
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $profit_monitor;
    /**
     * The profit_guarantee
     * Meta informations extracted from the WSDL
     * - documentation: Choose only routes which guarantee profit: Y - yes, N - no
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $profit_guarantee;
    /**
     * The profit_min_abs
     * Meta informations extracted from the WSDL
     * - documentation: Minimum Absolute Profit, Base Currency/minute
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $profit_min_abs;
    /**
     * The profit_combination
     * Meta informations extracted from the WSDL
     * - documentation: Combination: AND or OR
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $profit_combination;
    /**
     * The profit_min_rel
     * Meta informations extracted from the WSDL
     * - documentation: Minimum Relative Profit, %
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $profit_min_rel;
    /**
     * The profit_dispersion
     * Meta informations extracted from the WSDL
     * - documentation: Round-robin between routes with cost difference under, Base Currency/minute
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $profit_dispersion;
    /**
     * The utilization_cost_diff_limit
     * Meta informations extracted from the WSDL
     * - documentation: Overload Handicap, Base Currency/minute
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $utilization_cost_diff_limit;
    /**
     * Constructor method for WCRoutingPlanInfo
     * @uses WCRoutingPlanInfo::setName()
     * @uses WCRoutingPlanInfo::setCategories_enabled()
     * @uses WCRoutingPlanInfo::setOverride_routes_enabled()
     * @uses WCRoutingPlanInfo::setI_routing_plan()
     * @uses WCRoutingPlanInfo::setDescription()
     * @uses WCRoutingPlanInfo::setSelection_code()
     * @uses WCRoutingPlanInfo::setI_dest_group_set()
     * @uses WCRoutingPlanInfo::setProfit_monitor()
     * @uses WCRoutingPlanInfo::setProfit_guarantee()
     * @uses WCRoutingPlanInfo::setProfit_min_abs()
     * @uses WCRoutingPlanInfo::setProfit_combination()
     * @uses WCRoutingPlanInfo::setProfit_min_rel()
     * @uses WCRoutingPlanInfo::setProfit_dispersion()
     * @uses WCRoutingPlanInfo::setUtilization_cost_diff_limit()
     * @param string $name
     * @param string $categories_enabled
     * @param string $override_routes_enabled
     * @param int $i_routing_plan
     * @param string $description
     * @param string $selection_code
     * @param int $i_dest_group_set
     * @param string $profit_monitor
     * @param string $profit_guarantee
     * @param float $profit_min_abs
     * @param string $profit_combination
     * @param float $profit_min_rel
     * @param float $profit_dispersion
     * @param float $utilization_cost_diff_limit
     */
    public function __construct($name = null, $categories_enabled = null, $override_routes_enabled = null, $i_routing_plan = null, $description = null, $selection_code = null, $i_dest_group_set = null, $profit_monitor = null, $profit_guarantee = null, $profit_min_abs = null, $profit_combination = null, $profit_min_rel = null, $profit_dispersion = null, $utilization_cost_diff_limit = null)
    {
        $this
            ->setName($name)
            ->setCategories_enabled($categories_enabled)
            ->setOverride_routes_enabled($override_routes_enabled)
            ->setI_routing_plan($i_routing_plan)
            ->setDescription($description)
            ->setSelection_code($selection_code)
            ->setI_dest_group_set($i_dest_group_set)
            ->setProfit_monitor($profit_monitor)
            ->setProfit_guarantee($profit_guarantee)
            ->setProfit_min_abs($profit_min_abs)
            ->setProfit_combination($profit_combination)
            ->setProfit_min_rel($profit_min_rel)
            ->setProfit_dispersion($profit_dispersion)
            ->setUtilization_cost_diff_limit($utilization_cost_diff_limit);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get categories_enabled value
     * @return string
     */
    public function getCategories_enabled()
    {
        return $this->categories_enabled;
    }
    /**
     * Set categories_enabled value
     * @param string $categories_enabled
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setCategories_enabled($categories_enabled = null)
    {
        // validation for constraint: string
        if (!is_null($categories_enabled) && !is_string($categories_enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categories_enabled)), __LINE__);
        }
        $this->categories_enabled = $categories_enabled;
        return $this;
    }
    /**
     * Get override_routes_enabled value
     * @return string
     */
    public function getOverride_routes_enabled()
    {
        return $this->override_routes_enabled;
    }
    /**
     * Set override_routes_enabled value
     * @param string $override_routes_enabled
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setOverride_routes_enabled($override_routes_enabled = null)
    {
        // validation for constraint: string
        if (!is_null($override_routes_enabled) && !is_string($override_routes_enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($override_routes_enabled)), __LINE__);
        }
        $this->override_routes_enabled = $override_routes_enabled;
        return $this;
    }
    /**
     * Get i_routing_plan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_routing_plan()
    {
        return isset($this->i_routing_plan) ? $this->i_routing_plan : null;
    }
    /**
     * Set i_routing_plan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_routing_plan
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setI_routing_plan($i_routing_plan = null)
    {
        // validation for constraint: int
        if (!is_null($i_routing_plan) && !is_numeric($i_routing_plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_routing_plan)), __LINE__);
        }
        if (is_null($i_routing_plan) || (is_array($i_routing_plan) && empty($i_routing_plan))) {
            unset($this->i_routing_plan);
        } else {
            $this->i_routing_plan = $i_routing_plan;
        }
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get selection_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelection_code()
    {
        return isset($this->selection_code) ? $this->selection_code : null;
    }
    /**
     * Set selection_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selection_code
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setSelection_code($selection_code = null)
    {
        // validation for constraint: string
        if (!is_null($selection_code) && !is_string($selection_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selection_code)), __LINE__);
        }
        if (is_null($selection_code) || (is_array($selection_code) && empty($selection_code))) {
            unset($this->selection_code);
        } else {
            $this->selection_code = $selection_code;
        }
        return $this;
    }
    /**
     * Get i_dest_group_set value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_dest_group_set()
    {
        return isset($this->i_dest_group_set) ? $this->i_dest_group_set : null;
    }
    /**
     * Set i_dest_group_set value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_dest_group_set
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setI_dest_group_set($i_dest_group_set = null)
    {
        // validation for constraint: int
        if (!is_null($i_dest_group_set) && !is_numeric($i_dest_group_set)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_dest_group_set)), __LINE__);
        }
        if (is_null($i_dest_group_set) || (is_array($i_dest_group_set) && empty($i_dest_group_set))) {
            unset($this->i_dest_group_set);
        } else {
            $this->i_dest_group_set = $i_dest_group_set;
        }
        return $this;
    }
    /**
     * Get profit_monitor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProfit_monitor()
    {
        return isset($this->profit_monitor) ? $this->profit_monitor : null;
    }
    /**
     * Set profit_monitor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $profit_monitor
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setProfit_monitor($profit_monitor = null)
    {
        // validation for constraint: string
        if (!is_null($profit_monitor) && !is_string($profit_monitor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profit_monitor)), __LINE__);
        }
        if (is_null($profit_monitor) || (is_array($profit_monitor) && empty($profit_monitor))) {
            unset($this->profit_monitor);
        } else {
            $this->profit_monitor = $profit_monitor;
        }
        return $this;
    }
    /**
     * Get profit_guarantee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProfit_guarantee()
    {
        return isset($this->profit_guarantee) ? $this->profit_guarantee : null;
    }
    /**
     * Set profit_guarantee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $profit_guarantee
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setProfit_guarantee($profit_guarantee = null)
    {
        // validation for constraint: string
        if (!is_null($profit_guarantee) && !is_string($profit_guarantee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profit_guarantee)), __LINE__);
        }
        if (is_null($profit_guarantee) || (is_array($profit_guarantee) && empty($profit_guarantee))) {
            unset($this->profit_guarantee);
        } else {
            $this->profit_guarantee = $profit_guarantee;
        }
        return $this;
    }
    /**
     * Get profit_min_abs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getProfit_min_abs()
    {
        return isset($this->profit_min_abs) ? $this->profit_min_abs : null;
    }
    /**
     * Set profit_min_abs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $profit_min_abs
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setProfit_min_abs($profit_min_abs = null)
    {
        if (is_null($profit_min_abs) || (is_array($profit_min_abs) && empty($profit_min_abs))) {
            unset($this->profit_min_abs);
        } else {
            $this->profit_min_abs = $profit_min_abs;
        }
        return $this;
    }
    /**
     * Get profit_combination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProfit_combination()
    {
        return isset($this->profit_combination) ? $this->profit_combination : null;
    }
    /**
     * Set profit_combination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $profit_combination
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setProfit_combination($profit_combination = null)
    {
        // validation for constraint: string
        if (!is_null($profit_combination) && !is_string($profit_combination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profit_combination)), __LINE__);
        }
        if (is_null($profit_combination) || (is_array($profit_combination) && empty($profit_combination))) {
            unset($this->profit_combination);
        } else {
            $this->profit_combination = $profit_combination;
        }
        return $this;
    }
    /**
     * Get profit_min_rel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getProfit_min_rel()
    {
        return isset($this->profit_min_rel) ? $this->profit_min_rel : null;
    }
    /**
     * Set profit_min_rel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $profit_min_rel
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setProfit_min_rel($profit_min_rel = null)
    {
        if (is_null($profit_min_rel) || (is_array($profit_min_rel) && empty($profit_min_rel))) {
            unset($this->profit_min_rel);
        } else {
            $this->profit_min_rel = $profit_min_rel;
        }
        return $this;
    }
    /**
     * Get profit_dispersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getProfit_dispersion()
    {
        return isset($this->profit_dispersion) ? $this->profit_dispersion : null;
    }
    /**
     * Set profit_dispersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $profit_dispersion
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setProfit_dispersion($profit_dispersion = null)
    {
        if (is_null($profit_dispersion) || (is_array($profit_dispersion) && empty($profit_dispersion))) {
            unset($this->profit_dispersion);
        } else {
            $this->profit_dispersion = $profit_dispersion;
        }
        return $this;
    }
    /**
     * Get utilization_cost_diff_limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getUtilization_cost_diff_limit()
    {
        return isset($this->utilization_cost_diff_limit) ? $this->utilization_cost_diff_limit : null;
    }
    /**
     * Set utilization_cost_diff_limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $utilization_cost_diff_limit
     * @return \StructType\WCRoutingPlanInfo
     */
    public function setUtilization_cost_diff_limit($utilization_cost_diff_limit = null)
    {
        if (is_null($utilization_cost_diff_limit) || (is_array($utilization_cost_diff_limit) && empty($utilization_cost_diff_limit))) {
            unset($this->utilization_cost_diff_limit);
        } else {
            $this->utilization_cost_diff_limit = $utilization_cost_diff_limit;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCRoutingPlanInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
