<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCRouteCategoryInfo StructType
 * @subpackage Structs
 */
class WCRouteCategoryInfo extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Name of the category on the PortaBilling100 interface, unique in the environment, mandatory, 32 chars max
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The i_route_category
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of the category
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_route_category;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Description of the category, 255 chars max
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * Constructor method for WCRouteCategoryInfo
     * @uses WCRouteCategoryInfo::setName()
     * @uses WCRouteCategoryInfo::setI_route_category()
     * @uses WCRouteCategoryInfo::setDescription()
     * @param string $name
     * @param int $i_route_category
     * @param string $description
     */
    public function __construct($name = null, $i_route_category = null, $description = null)
    {
        $this
            ->setName($name)
            ->setI_route_category($i_route_category)
            ->setDescription($description);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\WCRouteCategoryInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get i_route_category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_route_category()
    {
        return isset($this->i_route_category) ? $this->i_route_category : null;
    }
    /**
     * Set i_route_category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_route_category
     * @return \StructType\WCRouteCategoryInfo
     */
    public function setI_route_category($i_route_category = null)
    {
        // validation for constraint: int
        if (!is_null($i_route_category) && !is_numeric($i_route_category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_route_category)), __LINE__);
        }
        if (is_null($i_route_category) || (is_array($i_route_category) && empty($i_route_category))) {
            unset($this->i_route_category);
        } else {
            $this->i_route_category = $i_route_category;
        }
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\WCRouteCategoryInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCRouteCategoryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
