<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCGetProductTariffsRequest StructType
 * @subpackage Structs
 */
class WCGetProductTariffsRequest extends AbstractStructBase
{
    /**
     * The i_product
     * Meta informations extracted from the WSDL
     * - documentation: Product which tariffs need to be listed
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_product;
    /**
     * The i_service
     * Meta informations extracted from the WSDL
     * - documentation: Service ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_service;
    /**
     * Constructor method for WCGetProductTariffsRequest
     * @uses WCGetProductTariffsRequest::setI_product()
     * @uses WCGetProductTariffsRequest::setI_service()
     * @param int $i_product
     * @param int $i_service
     */
    public function __construct($i_product = null, $i_service = null)
    {
        $this
            ->setI_product($i_product)
            ->setI_service($i_service);
    }
    /**
     * Get i_product value
     * @return int
     */
    public function getI_product()
    {
        return $this->i_product;
    }
    /**
     * Set i_product value
     * @param int $i_product
     * @return \StructType\WCGetProductTariffsRequest
     */
    public function setI_product($i_product = null)
    {
        // validation for constraint: int
        if (!is_null($i_product) && !is_numeric($i_product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_product)), __LINE__);
        }
        $this->i_product = $i_product;
        return $this;
    }
    /**
     * Get i_service value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_service()
    {
        return isset($this->i_service) ? $this->i_service : null;
    }
    /**
     * Set i_service value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_service
     * @return \StructType\WCGetProductTariffsRequest
     */
    public function setI_service($i_service = null)
    {
        // validation for constraint: int
        if (!is_null($i_service) && !is_numeric($i_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service)), __LINE__);
        }
        if (is_null($i_service) || (is_array($i_service) && empty($i_service))) {
            unset($this->i_service);
        } else {
            $this->i_service = $i_service;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCGetProductTariffsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
