<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCGetCardInventoryRequest StructType
 * @subpackage Structs
 */
class WCGetCardInventoryRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - documentation: Customer that owns card inventory
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $i_customer;
    /**
     * The card_i_account
     * Meta informations extracted from the WSDL
     * - documentation: ID of the IPlife card account that belongs to the card inventory
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $card_i_account;
    /**
     * Constructor method for WCGetCardInventoryRequest
     * @uses WCGetCardInventoryRequest::setI_customer()
     * @uses WCGetCardInventoryRequest::setCard_i_account()
     * @param int $i_customer
     * @param int $card_i_account
     */
    public function __construct($i_customer = null, $card_i_account = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setCard_i_account($card_i_account);
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\WCGetCardInventoryRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get card_i_account value
     * @return int|null
     */
    public function getCard_i_account()
    {
        return $this->card_i_account;
    }
    /**
     * Set card_i_account value
     * @param int $card_i_account
     * @return \StructType\WCGetCardInventoryRequest
     */
    public function setCard_i_account($card_i_account = null)
    {
        // validation for constraint: int
        if (!is_null($card_i_account) && !is_numeric($card_i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($card_i_account)), __LINE__);
        }
        $this->card_i_account = $card_i_account;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCGetCardInventoryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
