<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCGetAccountIDResponse StructType
 * @subpackage Structs
 */
class WCGetAccountIDResponse extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - documentation: ID of the account record
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_account;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Found account id
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $id;
    /**
     * Constructor method for WCGetAccountIDResponse
     * @uses WCGetAccountIDResponse::setI_account()
     * @uses WCGetAccountIDResponse::setId()
     * @param int $i_account
     * @param string $id
     */
    public function __construct($i_account = null, $id = null)
    {
        $this
            ->setI_account($i_account)
            ->setId($id);
    }
    /**
     * Get i_account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_account()
    {
        return isset($this->i_account) ? $this->i_account : null;
    }
    /**
     * Set i_account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_account
     * @return \StructType\WCGetAccountIDResponse
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        if (is_null($i_account) || (is_array($i_account) && empty($i_account))) {
            unset($this->i_account);
        } else {
            $this->i_account = $i_account;
        }
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \StructType\WCGetAccountIDResponse
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCGetAccountIDResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
