<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCCardInventoryEntryInfo StructType
 * @subpackage Structs
 */
class WCCardInventoryEntryInfo extends AbstractStructBase
{
    /**
     * The card_i_account
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of the IPlife card account
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $card_i_account;
    /**
     * The phone_i_account
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of the IPlife phone account
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $phone_i_account;
    /**
     * Constructor method for WCCardInventoryEntryInfo
     * @uses WCCardInventoryEntryInfo::setCard_i_account()
     * @uses WCCardInventoryEntryInfo::setPhone_i_account()
     * @param int $card_i_account
     * @param int $phone_i_account
     */
    public function __construct($card_i_account = null, $phone_i_account = null)
    {
        $this
            ->setCard_i_account($card_i_account)
            ->setPhone_i_account($phone_i_account);
    }
    /**
     * Get card_i_account value
     * @return int
     */
    public function getCard_i_account()
    {
        return $this->card_i_account;
    }
    /**
     * Set card_i_account value
     * @param int $card_i_account
     * @return \StructType\WCCardInventoryEntryInfo
     */
    public function setCard_i_account($card_i_account = null)
    {
        // validation for constraint: int
        if (!is_null($card_i_account) && !is_numeric($card_i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($card_i_account)), __LINE__);
        }
        $this->card_i_account = $card_i_account;
        return $this;
    }
    /**
     * Get phone_i_account value
     * @return int
     */
    public function getPhone_i_account()
    {
        return $this->phone_i_account;
    }
    /**
     * Set phone_i_account value
     * @param int $phone_i_account
     * @return \StructType\WCCardInventoryEntryInfo
     */
    public function setPhone_i_account($phone_i_account = null)
    {
        // validation for constraint: int
        if (!is_null($phone_i_account) && !is_numeric($phone_i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($phone_i_account)), __LINE__);
        }
        $this->phone_i_account = $phone_i_account;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCCardInventoryEntryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
