<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCAddServiceRatingRequest StructType
 * @subpackage Structs
 */
class WCAddServiceRatingRequest extends AbstractStructBase
{
    /**
     * The i_product
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of the product
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_product;
    /**
     * The service_rating_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\WCServiceRatingInfo
     */
    public $service_rating_info;
    /**
     * Constructor method for WCAddServiceRatingRequest
     * @uses WCAddServiceRatingRequest::setI_product()
     * @uses WCAddServiceRatingRequest::setService_rating_info()
     * @param int $i_product
     * @param \StructType\WCServiceRatingInfo $service_rating_info
     */
    public function __construct($i_product = null, \StructType\WCServiceRatingInfo $service_rating_info = null)
    {
        $this
            ->setI_product($i_product)
            ->setService_rating_info($service_rating_info);
    }
    /**
     * Get i_product value
     * @return int
     */
    public function getI_product()
    {
        return $this->i_product;
    }
    /**
     * Set i_product value
     * @param int $i_product
     * @return \StructType\WCAddServiceRatingRequest
     */
    public function setI_product($i_product = null)
    {
        // validation for constraint: int
        if (!is_null($i_product) && !is_numeric($i_product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_product)), __LINE__);
        }
        $this->i_product = $i_product;
        return $this;
    }
    /**
     * Get service_rating_info value
     * @return \StructType\WCServiceRatingInfo
     */
    public function getService_rating_info()
    {
        return $this->service_rating_info;
    }
    /**
     * Set service_rating_info value
     * @param \StructType\WCServiceRatingInfo $service_rating_info
     * @return \StructType\WCAddServiceRatingRequest
     */
    public function setService_rating_info(\StructType\WCServiceRatingInfo $service_rating_info = null)
    {
        $this->service_rating_info = $service_rating_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCAddServiceRatingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
