<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorBatchInfo StructType
 * @subpackage Structs
 */
class VendorBatchInfo extends AbstractStructBase
{
    /**
     * The i_dv_batch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_dv_batch;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The area_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $area_code;
    /**
     * The area_code_description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $area_code_description;
    /**
     * Constructor method for VendorBatchInfo
     * @uses VendorBatchInfo::setI_dv_batch()
     * @uses VendorBatchInfo::setName()
     * @uses VendorBatchInfo::setCountry()
     * @uses VendorBatchInfo::setArea_code()
     * @uses VendorBatchInfo::setArea_code_description()
     * @param int $i_dv_batch
     * @param string $name
     * @param string $country
     * @param string $area_code
     * @param string $area_code_description
     */
    public function __construct($i_dv_batch = null, $name = null, $country = null, $area_code = null, $area_code_description = null)
    {
        $this
            ->setI_dv_batch($i_dv_batch)
            ->setName($name)
            ->setCountry($country)
            ->setArea_code($area_code)
            ->setArea_code_description($area_code_description);
    }
    /**
     * Get i_dv_batch value
     * @return int|null
     */
    public function getI_dv_batch()
    {
        return $this->i_dv_batch;
    }
    /**
     * Set i_dv_batch value
     * @param int $i_dv_batch
     * @return \StructType\VendorBatchInfo
     */
    public function setI_dv_batch($i_dv_batch = null)
    {
        // validation for constraint: int
        if (!is_null($i_dv_batch) && !is_numeric($i_dv_batch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_dv_batch)), __LINE__);
        }
        $this->i_dv_batch = $i_dv_batch;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\VendorBatchInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\VendorBatchInfo
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get area_code value
     * @return string|null
     */
    public function getArea_code()
    {
        return $this->area_code;
    }
    /**
     * Set area_code value
     * @param string $area_code
     * @return \StructType\VendorBatchInfo
     */
    public function setArea_code($area_code = null)
    {
        // validation for constraint: string
        if (!is_null($area_code) && !is_string($area_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($area_code)), __LINE__);
        }
        $this->area_code = $area_code;
        return $this;
    }
    /**
     * Get area_code_description value
     * @return string|null
     */
    public function getArea_code_description()
    {
        return $this->area_code_description;
    }
    /**
     * Set area_code_description value
     * @param string $area_code_description
     * @return \StructType\VendorBatchInfo
     */
    public function setArea_code_description($area_code_description = null)
    {
        // validation for constraint: string
        if (!is_null($area_code_description) && !is_string($area_code_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($area_code_description)), __LINE__);
        }
        $this->area_code_description = $area_code_description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorBatchInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
