<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerSubscriptionRequest StructType
 * @subpackage Structs
 */
class UpdateCustomerSubscriptionRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_customer;
    /**
     * The i_customer_subscription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_customer_subscription;
    /**
     * The subscription_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CustomerSubscriptionInfo
     */
    public $subscription_info;
    /**
     * Constructor method for UpdateCustomerSubscriptionRequest
     * @uses UpdateCustomerSubscriptionRequest::setI_customer()
     * @uses UpdateCustomerSubscriptionRequest::setI_customer_subscription()
     * @uses UpdateCustomerSubscriptionRequest::setSubscription_info()
     * @param int $i_customer
     * @param int $i_customer_subscription
     * @param \StructType\CustomerSubscriptionInfo $subscription_info
     */
    public function __construct($i_customer = null, $i_customer_subscription = null, \StructType\CustomerSubscriptionInfo $subscription_info = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setI_customer_subscription($i_customer_subscription)
            ->setSubscription_info($subscription_info);
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\UpdateCustomerSubscriptionRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get i_customer_subscription value
     * @return int
     */
    public function getI_customer_subscription()
    {
        return $this->i_customer_subscription;
    }
    /**
     * Set i_customer_subscription value
     * @param int $i_customer_subscription
     * @return \StructType\UpdateCustomerSubscriptionRequest
     */
    public function setI_customer_subscription($i_customer_subscription = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer_subscription) && !is_numeric($i_customer_subscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer_subscription)), __LINE__);
        }
        $this->i_customer_subscription = $i_customer_subscription;
        return $this;
    }
    /**
     * Get subscription_info value
     * @return \StructType\CustomerSubscriptionInfo
     */
    public function getSubscription_info()
    {
        return $this->subscription_info;
    }
    /**
     * Set subscription_info value
     * @param \StructType\CustomerSubscriptionInfo $subscription_info
     * @return \StructType\UpdateCustomerSubscriptionRequest
     */
    public function setSubscription_info(\StructType\CustomerSubscriptionInfo $subscription_info = null)
    {
        $this->subscription_info = $subscription_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCustomerSubscriptionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
