<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerPaymentMethodRequest StructType
 * @subpackage Structs
 */
class UpdateCustomerPaymentMethodRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_customer;
    /**
     * The payment_method_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaymentMethodInfo
     */
    public $payment_method_info;
    /**
     * Constructor method for UpdateCustomerPaymentMethodRequest
     * @uses UpdateCustomerPaymentMethodRequest::setI_customer()
     * @uses UpdateCustomerPaymentMethodRequest::setPayment_method_info()
     * @param int $i_customer
     * @param \StructType\PaymentMethodInfo $payment_method_info
     */
    public function __construct($i_customer = null, \StructType\PaymentMethodInfo $payment_method_info = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setPayment_method_info($payment_method_info);
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\UpdateCustomerPaymentMethodRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get payment_method_info value
     * @return \StructType\PaymentMethodInfo
     */
    public function getPayment_method_info()
    {
        return $this->payment_method_info;
    }
    /**
     * Set payment_method_info value
     * @param \StructType\PaymentMethodInfo $payment_method_info
     * @return \StructType\UpdateCustomerPaymentMethodRequest
     */
    public function setPayment_method_info(\StructType\PaymentMethodInfo $payment_method_info = null)
    {
        $this->payment_method_info = $payment_method_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCustomerPaymentMethodRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
