<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopupAccountRequest StructType
 * @subpackage Structs
 */
class TopupAccountRequest extends AbstractStructBase
{
    /**
     * The account_info
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\AccountInfo
     */
    public $account_info;
    /**
     * The voucher_info
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\VoucherInfo
     */
    public $voucher_info;
    /**
     * Constructor method for TopupAccountRequest
     * @uses TopupAccountRequest::setAccount_info()
     * @uses TopupAccountRequest::setVoucher_info()
     * @param \StructType\AccountInfo $account_info
     * @param \StructType\VoucherInfo $voucher_info
     */
    public function __construct(\StructType\AccountInfo $account_info = null, \StructType\VoucherInfo $voucher_info = null)
    {
        $this
            ->setAccount_info($account_info)
            ->setVoucher_info($voucher_info);
    }
    /**
     * Get account_info value
     * @return \StructType\AccountInfo
     */
    public function getAccount_info()
    {
        return $this->account_info;
    }
    /**
     * Set account_info value
     * @param \StructType\AccountInfo $account_info
     * @return \StructType\TopupAccountRequest
     */
    public function setAccount_info(\StructType\AccountInfo $account_info = null)
    {
        $this->account_info = $account_info;
        return $this;
    }
    /**
     * Get voucher_info value
     * @return \StructType\VoucherInfo
     */
    public function getVoucher_info()
    {
        return $this->voucher_info;
    }
    /**
     * Set voucher_info value
     * @param \StructType\VoucherInfo $voucher_info
     * @return \StructType\TopupAccountRequest
     */
    public function setVoucher_info(\StructType\VoucherInfo $voucher_info = null)
    {
        $this->voucher_info = $voucher_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TopupAccountRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
