<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxationOptionsVat StructType
 * @subpackage Structs
 */
class TaxationOptionsVat extends AbstractStructBase
{
    /**
     * The exempt
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $exempt;
    /**
     * The percent
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $percent;
    /**
     * The xdr_per_service
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $xdr_per_service;
    /**
     * Constructor method for TaxationOptionsVat
     * @uses TaxationOptionsVat::setExempt()
     * @uses TaxationOptionsVat::setPercent()
     * @uses TaxationOptionsVat::setXdr_per_service()
     * @param string $exempt
     * @param int $percent
     * @param int $xdr_per_service
     */
    public function __construct($exempt = null, $percent = null, $xdr_per_service = null)
    {
        $this
            ->setExempt($exempt)
            ->setPercent($percent)
            ->setXdr_per_service($xdr_per_service);
    }
    /**
     * Get exempt value
     * @return string
     */
    public function getExempt()
    {
        return $this->exempt;
    }
    /**
     * Set exempt value
     * @param string $exempt
     * @return \StructType\TaxationOptionsVat
     */
    public function setExempt($exempt = null)
    {
        // validation for constraint: string
        if (!is_null($exempt) && !is_string($exempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exempt)), __LINE__);
        }
        $this->exempt = $exempt;
        return $this;
    }
    /**
     * Get percent value
     * @return int|null
     */
    public function getPercent()
    {
        return $this->percent;
    }
    /**
     * Set percent value
     * @param int $percent
     * @return \StructType\TaxationOptionsVat
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: int
        if (!is_null($percent) && !is_numeric($percent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($percent)), __LINE__);
        }
        $this->percent = $percent;
        return $this;
    }
    /**
     * Get xdr_per_service value
     * @return int|null
     */
    public function getXdr_per_service()
    {
        return $this->xdr_per_service;
    }
    /**
     * Set xdr_per_service value
     * @param int $xdr_per_service
     * @return \StructType\TaxationOptionsVat
     */
    public function setXdr_per_service($xdr_per_service = null)
    {
        // validation for constraint: int
        if (!is_null($xdr_per_service) && !is_numeric($xdr_per_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($xdr_per_service)), __LINE__);
        }
        $this->xdr_per_service = $xdr_per_service;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxationOptionsVat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
