<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TariffInfo StructType
 * @subpackage Structs
 */
class TariffInfo extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The i_tariff
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_tariff;
    /**
     * The period
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $period;
    /**
     * The i_offpeak
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_offpeak;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The free_sec
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $free_sec;
    /**
     * The connect_fee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $connect_fee;
    /**
     * The login_fee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $login_fee;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The post_call_surcharge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $post_call_surcharge;
    /**
     * The i_tariff_template_upload
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_tariff_template_upload;
    /**
     * The i_tariff_template_download
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_tariff_template_download;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The short_description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $short_description;
    /**
     * The routing_ext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $routing_ext;
    /**
     * The volume_based
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $volume_based;
    /**
     * The i_dest_group_set
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_dest_group_set;
    /**
     * The rounding
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $rounding;
    /**
     * The formula
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $formula;
    /**
     * The rating_mode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rating_mode;
    /**
     * The i_service
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_service;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The usage_update
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usage_update;
    /**
     * Constructor method for TariffInfo
     * @uses TariffInfo::setName()
     * @uses TariffInfo::setI_tariff()
     * @uses TariffInfo::setPeriod()
     * @uses TariffInfo::setI_offpeak()
     * @uses TariffInfo::setCurrency()
     * @uses TariffInfo::setFree_sec()
     * @uses TariffInfo::setConnect_fee()
     * @uses TariffInfo::setLogin_fee()
     * @uses TariffInfo::setDescription()
     * @uses TariffInfo::setPost_call_surcharge()
     * @uses TariffInfo::setI_tariff_template_upload()
     * @uses TariffInfo::setI_tariff_template_download()
     * @uses TariffInfo::setI_customer()
     * @uses TariffInfo::setShort_description()
     * @uses TariffInfo::setRouting_ext()
     * @uses TariffInfo::setVolume_based()
     * @uses TariffInfo::setI_dest_group_set()
     * @uses TariffInfo::setRounding()
     * @uses TariffInfo::setFormula()
     * @uses TariffInfo::setRating_mode()
     * @uses TariffInfo::setI_service()
     * @uses TariffInfo::setType()
     * @uses TariffInfo::setUsage_update()
     * @param string $name
     * @param int $i_tariff
     * @param string $period
     * @param int $i_offpeak
     * @param string $currency
     * @param int $free_sec
     * @param float $connect_fee
     * @param float $login_fee
     * @param string $description
     * @param float $post_call_surcharge
     * @param int $i_tariff_template_upload
     * @param int $i_tariff_template_download
     * @param int $i_customer
     * @param string $short_description
     * @param string $routing_ext
     * @param string $volume_based
     * @param int $i_dest_group_set
     * @param int $rounding
     * @param string $formula
     * @param string $rating_mode
     * @param int $i_service
     * @param string $type
     * @param string $usage_update
     */
    public function __construct($name = null, $i_tariff = null, $period = null, $i_offpeak = null, $currency = null, $free_sec = null, $connect_fee = null, $login_fee = null, $description = null, $post_call_surcharge = null, $i_tariff_template_upload = null, $i_tariff_template_download = null, $i_customer = null, $short_description = null, $routing_ext = null, $volume_based = null, $i_dest_group_set = null, $rounding = null, $formula = null, $rating_mode = null, $i_service = null, $type = null, $usage_update = null)
    {
        $this
            ->setName($name)
            ->setI_tariff($i_tariff)
            ->setPeriod($period)
            ->setI_offpeak($i_offpeak)
            ->setCurrency($currency)
            ->setFree_sec($free_sec)
            ->setConnect_fee($connect_fee)
            ->setLogin_fee($login_fee)
            ->setDescription($description)
            ->setPost_call_surcharge($post_call_surcharge)
            ->setI_tariff_template_upload($i_tariff_template_upload)
            ->setI_tariff_template_download($i_tariff_template_download)
            ->setI_customer($i_customer)
            ->setShort_description($short_description)
            ->setRouting_ext($routing_ext)
            ->setVolume_based($volume_based)
            ->setI_dest_group_set($i_dest_group_set)
            ->setRounding($rounding)
            ->setFormula($formula)
            ->setRating_mode($rating_mode)
            ->setI_service($i_service)
            ->setType($type)
            ->setUsage_update($usage_update);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\TariffInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get i_tariff value
     * @return int|null
     */
    public function getI_tariff()
    {
        return $this->i_tariff;
    }
    /**
     * Set i_tariff value
     * @param int $i_tariff
     * @return \StructType\TariffInfo
     */
    public function setI_tariff($i_tariff = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff) && !is_numeric($i_tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff)), __LINE__);
        }
        $this->i_tariff = $i_tariff;
        return $this;
    }
    /**
     * Get period value
     * @return string|null
     */
    public function getPeriod()
    {
        return $this->period;
    }
    /**
     * Set period value
     * @param string $period
     * @return \StructType\TariffInfo
     */
    public function setPeriod($period = null)
    {
        // validation for constraint: string
        if (!is_null($period) && !is_string($period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($period)), __LINE__);
        }
        $this->period = $period;
        return $this;
    }
    /**
     * Get i_offpeak value
     * @return int|null
     */
    public function getI_offpeak()
    {
        return $this->i_offpeak;
    }
    /**
     * Set i_offpeak value
     * @param int $i_offpeak
     * @return \StructType\TariffInfo
     */
    public function setI_offpeak($i_offpeak = null)
    {
        // validation for constraint: int
        if (!is_null($i_offpeak) && !is_numeric($i_offpeak)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_offpeak)), __LINE__);
        }
        $this->i_offpeak = $i_offpeak;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\TariffInfo
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get free_sec value
     * @return int|null
     */
    public function getFree_sec()
    {
        return $this->free_sec;
    }
    /**
     * Set free_sec value
     * @param int $free_sec
     * @return \StructType\TariffInfo
     */
    public function setFree_sec($free_sec = null)
    {
        // validation for constraint: int
        if (!is_null($free_sec) && !is_numeric($free_sec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($free_sec)), __LINE__);
        }
        $this->free_sec = $free_sec;
        return $this;
    }
    /**
     * Get connect_fee value
     * @return float|null
     */
    public function getConnect_fee()
    {
        return $this->connect_fee;
    }
    /**
     * Set connect_fee value
     * @param float $connect_fee
     * @return \StructType\TariffInfo
     */
    public function setConnect_fee($connect_fee = null)
    {
        $this->connect_fee = $connect_fee;
        return $this;
    }
    /**
     * Get login_fee value
     * @return float|null
     */
    public function getLogin_fee()
    {
        return $this->login_fee;
    }
    /**
     * Set login_fee value
     * @param float $login_fee
     * @return \StructType\TariffInfo
     */
    public function setLogin_fee($login_fee = null)
    {
        $this->login_fee = $login_fee;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\TariffInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get post_call_surcharge value
     * @return float|null
     */
    public function getPost_call_surcharge()
    {
        return $this->post_call_surcharge;
    }
    /**
     * Set post_call_surcharge value
     * @param float $post_call_surcharge
     * @return \StructType\TariffInfo
     */
    public function setPost_call_surcharge($post_call_surcharge = null)
    {
        $this->post_call_surcharge = $post_call_surcharge;
        return $this;
    }
    /**
     * Get i_tariff_template_upload value
     * @return int|null
     */
    public function getI_tariff_template_upload()
    {
        return $this->i_tariff_template_upload;
    }
    /**
     * Set i_tariff_template_upload value
     * @param int $i_tariff_template_upload
     * @return \StructType\TariffInfo
     */
    public function setI_tariff_template_upload($i_tariff_template_upload = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff_template_upload) && !is_numeric($i_tariff_template_upload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff_template_upload)), __LINE__);
        }
        $this->i_tariff_template_upload = $i_tariff_template_upload;
        return $this;
    }
    /**
     * Get i_tariff_template_download value
     * @return int|null
     */
    public function getI_tariff_template_download()
    {
        return $this->i_tariff_template_download;
    }
    /**
     * Set i_tariff_template_download value
     * @param int $i_tariff_template_download
     * @return \StructType\TariffInfo
     */
    public function setI_tariff_template_download($i_tariff_template_download = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff_template_download) && !is_numeric($i_tariff_template_download)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff_template_download)), __LINE__);
        }
        $this->i_tariff_template_download = $i_tariff_template_download;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\TariffInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get short_description value
     * @return string|null
     */
    public function getShort_description()
    {
        return $this->short_description;
    }
    /**
     * Set short_description value
     * @param string $short_description
     * @return \StructType\TariffInfo
     */
    public function setShort_description($short_description = null)
    {
        // validation for constraint: string
        if (!is_null($short_description) && !is_string($short_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($short_description)), __LINE__);
        }
        $this->short_description = $short_description;
        return $this;
    }
    /**
     * Get routing_ext value
     * @return string|null
     */
    public function getRouting_ext()
    {
        return $this->routing_ext;
    }
    /**
     * Set routing_ext value
     * @param string $routing_ext
     * @return \StructType\TariffInfo
     */
    public function setRouting_ext($routing_ext = null)
    {
        // validation for constraint: string
        if (!is_null($routing_ext) && !is_string($routing_ext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routing_ext)), __LINE__);
        }
        $this->routing_ext = $routing_ext;
        return $this;
    }
    /**
     * Get volume_based value
     * @return string|null
     */
    public function getVolume_based()
    {
        return $this->volume_based;
    }
    /**
     * Set volume_based value
     * @param string $volume_based
     * @return \StructType\TariffInfo
     */
    public function setVolume_based($volume_based = null)
    {
        // validation for constraint: string
        if (!is_null($volume_based) && !is_string($volume_based)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($volume_based)), __LINE__);
        }
        $this->volume_based = $volume_based;
        return $this;
    }
    /**
     * Get i_dest_group_set value
     * @return int|null
     */
    public function getI_dest_group_set()
    {
        return $this->i_dest_group_set;
    }
    /**
     * Set i_dest_group_set value
     * @param int $i_dest_group_set
     * @return \StructType\TariffInfo
     */
    public function setI_dest_group_set($i_dest_group_set = null)
    {
        // validation for constraint: int
        if (!is_null($i_dest_group_set) && !is_numeric($i_dest_group_set)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_dest_group_set)), __LINE__);
        }
        $this->i_dest_group_set = $i_dest_group_set;
        return $this;
    }
    /**
     * Get rounding value
     * @return int|null
     */
    public function getRounding()
    {
        return $this->rounding;
    }
    /**
     * Set rounding value
     * @param int $rounding
     * @return \StructType\TariffInfo
     */
    public function setRounding($rounding = null)
    {
        // validation for constraint: int
        if (!is_null($rounding) && !is_numeric($rounding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rounding)), __LINE__);
        }
        $this->rounding = $rounding;
        return $this;
    }
    /**
     * Get formula value
     * @return string|null
     */
    public function getFormula()
    {
        return $this->formula;
    }
    /**
     * Set formula value
     * @param string $formula
     * @return \StructType\TariffInfo
     */
    public function setFormula($formula = null)
    {
        // validation for constraint: string
        if (!is_null($formula) && !is_string($formula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formula)), __LINE__);
        }
        $this->formula = $formula;
        return $this;
    }
    /**
     * Get rating_mode value
     * @return string|null
     */
    public function getRating_mode()
    {
        return $this->rating_mode;
    }
    /**
     * Set rating_mode value
     * @param string $rating_mode
     * @return \StructType\TariffInfo
     */
    public function setRating_mode($rating_mode = null)
    {
        // validation for constraint: string
        if (!is_null($rating_mode) && !is_string($rating_mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rating_mode)), __LINE__);
        }
        $this->rating_mode = $rating_mode;
        return $this;
    }
    /**
     * Get i_service value
     * @return int|null
     */
    public function getI_service()
    {
        return $this->i_service;
    }
    /**
     * Set i_service value
     * @param int $i_service
     * @return \StructType\TariffInfo
     */
    public function setI_service($i_service = null)
    {
        // validation for constraint: int
        if (!is_null($i_service) && !is_numeric($i_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service)), __LINE__);
        }
        $this->i_service = $i_service;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\TariffInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get usage_update value
     * @return string|null
     */
    public function getUsage_update()
    {
        return $this->usage_update;
    }
    /**
     * Set usage_update value
     * @param string $usage_update
     * @return \StructType\TariffInfo
     */
    public function setUsage_update($usage_update = null)
    {
        // validation for constraint: string
        if (!is_null($usage_update) && !is_string($usage_update)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usage_update)), __LINE__);
        }
        $this->usage_update = $usage_update;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TariffInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
