<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceFeaturesConflicts StructType
 * @subpackage Structs
 */
class ServiceFeaturesConflicts extends AbstractStructBase
{
    /**
     * The sf_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sf_name;
    /**
     * The addon_precedence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $addon_precedence;
    /**
     * The conflicting_addons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:ConflictingAddOns[]
     * - ref: soapenc:arrayType
     * @var \StructType\ConflictingAddOns[]
     */
    public $conflicting_addons;
    /**
     * Constructor method for ServiceFeaturesConflicts
     * @uses ServiceFeaturesConflicts::setSf_name()
     * @uses ServiceFeaturesConflicts::setAddon_precedence()
     * @uses ServiceFeaturesConflicts::setConflicting_addons()
     * @param string $sf_name
     * @param string $addon_precedence
     * @param \StructType\ConflictingAddOns[] $conflicting_addons
     */
    public function __construct($sf_name = null, $addon_precedence = null, array $conflicting_addons = array())
    {
        $this
            ->setSf_name($sf_name)
            ->setAddon_precedence($addon_precedence)
            ->setConflicting_addons($conflicting_addons);
    }
    /**
     * Get sf_name value
     * @return string|null
     */
    public function getSf_name()
    {
        return $this->sf_name;
    }
    /**
     * Set sf_name value
     * @param string $sf_name
     * @return \StructType\ServiceFeaturesConflicts
     */
    public function setSf_name($sf_name = null)
    {
        // validation for constraint: string
        if (!is_null($sf_name) && !is_string($sf_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sf_name)), __LINE__);
        }
        $this->sf_name = $sf_name;
        return $this;
    }
    /**
     * Get addon_precedence value
     * @return string|null
     */
    public function getAddon_precedence()
    {
        return $this->addon_precedence;
    }
    /**
     * Set addon_precedence value
     * @param string $addon_precedence
     * @return \StructType\ServiceFeaturesConflicts
     */
    public function setAddon_precedence($addon_precedence = null)
    {
        // validation for constraint: string
        if (!is_null($addon_precedence) && !is_string($addon_precedence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addon_precedence)), __LINE__);
        }
        $this->addon_precedence = $addon_precedence;
        return $this;
    }
    /**
     * Get conflicting_addons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ConflictingAddOns[]|null
     */
    public function getConflicting_addons()
    {
        return isset($this->conflicting_addons) ? $this->conflicting_addons : null;
    }
    /**
     * Set conflicting_addons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ConflictingAddOns[] $conflicting_addons
     * @return \StructType\ServiceFeaturesConflicts
     */
    public function setConflicting_addons(array $conflicting_addons = array())
    {
        foreach ($conflicting_addons as $serviceFeaturesConflictsConflicting_addonsItem) {
            // validation for constraint: itemType
            if (!$serviceFeaturesConflictsConflicting_addonsItem instanceof \StructType\ConflictingAddOns) {
                throw new \InvalidArgumentException(sprintf('The conflicting_addons property can only contain items of \StructType\ConflictingAddOns, "%s" given', is_object($serviceFeaturesConflictsConflicting_addonsItem) ? get_class($serviceFeaturesConflictsConflicting_addonsItem) : gettype($serviceFeaturesConflictsConflicting_addonsItem)), __LINE__);
            }
        }
        if (is_null($conflicting_addons) || (is_array($conflicting_addons) && empty($conflicting_addons))) {
            unset($this->conflicting_addons);
        } else {
            $this->conflicting_addons = $conflicting_addons;
        }
        return $this;
    }
    /**
     * Add item to conflicting_addons value
     * @throws \InvalidArgumentException
     * @param \StructType\ConflictingAddOns $item
     * @return \StructType\ServiceFeaturesConflicts
     */
    public function addToConflicting_addons(\StructType\ConflictingAddOns $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConflictingAddOns) {
            throw new \InvalidArgumentException(sprintf('The conflicting_addons property can only contain items of \StructType\ConflictingAddOns, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->conflicting_addons[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceFeaturesConflicts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
