<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceAttributeInfo StructType
 * @subpackage Structs
 */
class ServiceAttributeInfo extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The values
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $values;
    /**
     * The effective_values
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $effective_values;
    /**
     * Constructor method for ServiceAttributeInfo
     * @uses ServiceAttributeInfo::setName()
     * @uses ServiceAttributeInfo::setValues()
     * @uses ServiceAttributeInfo::setEffective_values()
     * @param string $name
     * @param string[] $values
     * @param string[] $effective_values
     */
    public function __construct($name = null, array $values = array(), array $effective_values = array())
    {
        $this
            ->setName($name)
            ->setValues($values)
            ->setEffective_values($effective_values);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ServiceAttributeInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get values value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getValues()
    {
        return isset($this->values) ? $this->values : null;
    }
    /**
     * Set values value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $values
     * @return \StructType\ServiceAttributeInfo
     */
    public function setValues(array $values = array())
    {
        foreach ($values as $serviceAttributeInfoValuesItem) {
            // validation for constraint: itemType
            if (!is_string($serviceAttributeInfoValuesItem)) {
                throw new \InvalidArgumentException(sprintf('The values property can only contain items of string, "%s" given', is_object($serviceAttributeInfoValuesItem) ? get_class($serviceAttributeInfoValuesItem) : gettype($serviceAttributeInfoValuesItem)), __LINE__);
            }
        }
        if (is_null($values) || (is_array($values) && empty($values))) {
            unset($this->values);
        } else {
            $this->values = $values;
        }
        return $this;
    }
    /**
     * Add item to values value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ServiceAttributeInfo
     */
    public function addToValues($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The values property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->values[] = $item;
        return $this;
    }
    /**
     * Get effective_values value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getEffective_values()
    {
        return isset($this->effective_values) ? $this->effective_values : null;
    }
    /**
     * Set effective_values value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $effective_values
     * @return \StructType\ServiceAttributeInfo
     */
    public function setEffective_values(array $effective_values = array())
    {
        foreach ($effective_values as $serviceAttributeInfoEffective_valuesItem) {
            // validation for constraint: itemType
            if (!is_string($serviceAttributeInfoEffective_valuesItem)) {
                throw new \InvalidArgumentException(sprintf('The effective_values property can only contain items of string, "%s" given', is_object($serviceAttributeInfoEffective_valuesItem) ? get_class($serviceAttributeInfoEffective_valuesItem) : gettype($serviceAttributeInfoEffective_valuesItem)), __LINE__);
            }
        }
        if (is_null($effective_values) || (is_array($effective_values) && empty($effective_values))) {
            unset($this->effective_values);
        } else {
            $this->effective_values = $effective_values;
        }
        return $this;
    }
    /**
     * Add item to effective_values value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ServiceAttributeInfo
     */
    public function addToEffective_values($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The effective_values property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->effective_values[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceAttributeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
