<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReleaseDIDNumberRequest StructType
 * @subpackage Structs
 */
class ReleaseDIDNumberRequest extends AbstractStructBase
{
    /**
     * The number
     * @var string
     */
    public $number;
    /**
     * The timestamp
     * @var string
     */
    public $timestamp;
    /**
     * Constructor method for ReleaseDIDNumberRequest
     * @uses ReleaseDIDNumberRequest::setNumber()
     * @uses ReleaseDIDNumberRequest::setTimestamp()
     * @param string $number
     * @param string $timestamp
     */
    public function __construct($number = null, $timestamp = null)
    {
        $this
            ->setNumber($number)
            ->setTimestamp($timestamp);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\ReleaseDIDNumberRequest
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\ReleaseDIDNumberRequest
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReleaseDIDNumberRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
