<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductInfo StructType
 * @subpackage Structs
 */
class ProductInfo extends AbstractStructBase
{
    /**
     * The i_product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_product;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $iso_4217;
    /**
     * The maintenance_fee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $maintenance_fee;
    /**
     * The maintenance_period
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maintenance_period;
    /**
     * The breakage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $breakage;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The info_url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $info_url;
    /**
     * The default_i_acl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $default_i_acl;
    /**
     * The i_vd_plan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_vd_plan;
    /**
     * The subscription_host
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subscription_host;
    /**
     * The maintenance_effective_from
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $maintenance_effective_from;
    /**
     * The hidden
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hidden;
    /**
     * The fraud_protection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fraud_protection;
    /**
     * The addon_priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $addon_priority;
    /**
     * The service_flag_locks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $service_flag_locks;
    /**
     * Constructor method for ProductInfo
     * @uses ProductInfo::setI_product()
     * @uses ProductInfo::setName()
     * @uses ProductInfo::setIso_4217()
     * @uses ProductInfo::setMaintenance_fee()
     * @uses ProductInfo::setMaintenance_period()
     * @uses ProductInfo::setBreakage()
     * @uses ProductInfo::setI_customer()
     * @uses ProductInfo::setDescription()
     * @uses ProductInfo::setInfo_url()
     * @uses ProductInfo::setDefault_i_acl()
     * @uses ProductInfo::setI_vd_plan()
     * @uses ProductInfo::setSubscription_host()
     * @uses ProductInfo::setMaintenance_effective_from()
     * @uses ProductInfo::setHidden()
     * @uses ProductInfo::setFraud_protection()
     * @uses ProductInfo::setAddon_priority()
     * @uses ProductInfo::setService_flag_locks()
     * @param int $i_product
     * @param string $name
     * @param string $iso_4217
     * @param float $maintenance_fee
     * @param string $maintenance_period
     * @param float $breakage
     * @param int $i_customer
     * @param string $description
     * @param string $info_url
     * @param int $default_i_acl
     * @param int $i_vd_plan
     * @param string $subscription_host
     * @param string $maintenance_effective_from
     * @param string $hidden
     * @param string $fraud_protection
     * @param int $addon_priority
     * @param string $service_flag_locks
     */
    public function __construct($i_product = null, $name = null, $iso_4217 = null, $maintenance_fee = null, $maintenance_period = null, $breakage = null, $i_customer = null, $description = null, $info_url = null, $default_i_acl = null, $i_vd_plan = null, $subscription_host = null, $maintenance_effective_from = null, $hidden = null, $fraud_protection = null, $addon_priority = null, $service_flag_locks = null)
    {
        $this
            ->setI_product($i_product)
            ->setName($name)
            ->setIso_4217($iso_4217)
            ->setMaintenance_fee($maintenance_fee)
            ->setMaintenance_period($maintenance_period)
            ->setBreakage($breakage)
            ->setI_customer($i_customer)
            ->setDescription($description)
            ->setInfo_url($info_url)
            ->setDefault_i_acl($default_i_acl)
            ->setI_vd_plan($i_vd_plan)
            ->setSubscription_host($subscription_host)
            ->setMaintenance_effective_from($maintenance_effective_from)
            ->setHidden($hidden)
            ->setFraud_protection($fraud_protection)
            ->setAddon_priority($addon_priority)
            ->setService_flag_locks($service_flag_locks);
    }
    /**
     * Get i_product value
     * @return int|null
     */
    public function getI_product()
    {
        return $this->i_product;
    }
    /**
     * Set i_product value
     * @param int $i_product
     * @return \StructType\ProductInfo
     */
    public function setI_product($i_product = null)
    {
        // validation for constraint: int
        if (!is_null($i_product) && !is_numeric($i_product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_product)), __LINE__);
        }
        $this->i_product = $i_product;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ProductInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get iso_4217 value
     * @return string|null
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\ProductInfo
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Get maintenance_fee value
     * @return float|null
     */
    public function getMaintenance_fee()
    {
        return $this->maintenance_fee;
    }
    /**
     * Set maintenance_fee value
     * @param float $maintenance_fee
     * @return \StructType\ProductInfo
     */
    public function setMaintenance_fee($maintenance_fee = null)
    {
        $this->maintenance_fee = $maintenance_fee;
        return $this;
    }
    /**
     * Get maintenance_period value
     * @return string|null
     */
    public function getMaintenance_period()
    {
        return $this->maintenance_period;
    }
    /**
     * Set maintenance_period value
     * @param string $maintenance_period
     * @return \StructType\ProductInfo
     */
    public function setMaintenance_period($maintenance_period = null)
    {
        // validation for constraint: string
        if (!is_null($maintenance_period) && !is_string($maintenance_period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maintenance_period)), __LINE__);
        }
        $this->maintenance_period = $maintenance_period;
        return $this;
    }
    /**
     * Get breakage value
     * @return float|null
     */
    public function getBreakage()
    {
        return $this->breakage;
    }
    /**
     * Set breakage value
     * @param float $breakage
     * @return \StructType\ProductInfo
     */
    public function setBreakage($breakage = null)
    {
        $this->breakage = $breakage;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\ProductInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\ProductInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get info_url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInfo_url()
    {
        return isset($this->info_url) ? $this->info_url : null;
    }
    /**
     * Set info_url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $info_url
     * @return \StructType\ProductInfo
     */
    public function setInfo_url($info_url = null)
    {
        // validation for constraint: string
        if (!is_null($info_url) && !is_string($info_url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($info_url)), __LINE__);
        }
        if (is_null($info_url) || (is_array($info_url) && empty($info_url))) {
            unset($this->info_url);
        } else {
            $this->info_url = $info_url;
        }
        return $this;
    }
    /**
     * Get default_i_acl value
     * @return int|null
     */
    public function getDefault_i_acl()
    {
        return $this->default_i_acl;
    }
    /**
     * Set default_i_acl value
     * @param int $default_i_acl
     * @return \StructType\ProductInfo
     */
    public function setDefault_i_acl($default_i_acl = null)
    {
        // validation for constraint: int
        if (!is_null($default_i_acl) && !is_numeric($default_i_acl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($default_i_acl)), __LINE__);
        }
        $this->default_i_acl = $default_i_acl;
        return $this;
    }
    /**
     * Get i_vd_plan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_vd_plan()
    {
        return isset($this->i_vd_plan) ? $this->i_vd_plan : null;
    }
    /**
     * Set i_vd_plan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_vd_plan
     * @return \StructType\ProductInfo
     */
    public function setI_vd_plan($i_vd_plan = null)
    {
        // validation for constraint: int
        if (!is_null($i_vd_plan) && !is_numeric($i_vd_plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_vd_plan)), __LINE__);
        }
        if (is_null($i_vd_plan) || (is_array($i_vd_plan) && empty($i_vd_plan))) {
            unset($this->i_vd_plan);
        } else {
            $this->i_vd_plan = $i_vd_plan;
        }
        return $this;
    }
    /**
     * Get subscription_host value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscription_host()
    {
        return isset($this->subscription_host) ? $this->subscription_host : null;
    }
    /**
     * Set subscription_host value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscription_host
     * @return \StructType\ProductInfo
     */
    public function setSubscription_host($subscription_host = null)
    {
        // validation for constraint: string
        if (!is_null($subscription_host) && !is_string($subscription_host)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscription_host)), __LINE__);
        }
        if (is_null($subscription_host) || (is_array($subscription_host) && empty($subscription_host))) {
            unset($this->subscription_host);
        } else {
            $this->subscription_host = $subscription_host;
        }
        return $this;
    }
    /**
     * Get maintenance_effective_from value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaintenance_effective_from()
    {
        return isset($this->maintenance_effective_from) ? $this->maintenance_effective_from : null;
    }
    /**
     * Set maintenance_effective_from value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maintenance_effective_from
     * @return \StructType\ProductInfo
     */
    public function setMaintenance_effective_from($maintenance_effective_from = null)
    {
        // validation for constraint: string
        if (!is_null($maintenance_effective_from) && !is_string($maintenance_effective_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maintenance_effective_from)), __LINE__);
        }
        if (is_null($maintenance_effective_from) || (is_array($maintenance_effective_from) && empty($maintenance_effective_from))) {
            unset($this->maintenance_effective_from);
        } else {
            $this->maintenance_effective_from = $maintenance_effective_from;
        }
        return $this;
    }
    /**
     * Get hidden value
     * @return string|null
     */
    public function getHidden()
    {
        return $this->hidden;
    }
    /**
     * Set hidden value
     * @param string $hidden
     * @return \StructType\ProductInfo
     */
    public function setHidden($hidden = null)
    {
        // validation for constraint: string
        if (!is_null($hidden) && !is_string($hidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hidden)), __LINE__);
        }
        $this->hidden = $hidden;
        return $this;
    }
    /**
     * Get fraud_protection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFraud_protection()
    {
        return isset($this->fraud_protection) ? $this->fraud_protection : null;
    }
    /**
     * Set fraud_protection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fraud_protection
     * @return \StructType\ProductInfo
     */
    public function setFraud_protection($fraud_protection = null)
    {
        // validation for constraint: string
        if (!is_null($fraud_protection) && !is_string($fraud_protection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fraud_protection)), __LINE__);
        }
        if (is_null($fraud_protection) || (is_array($fraud_protection) && empty($fraud_protection))) {
            unset($this->fraud_protection);
        } else {
            $this->fraud_protection = $fraud_protection;
        }
        return $this;
    }
    /**
     * Get addon_priority value
     * @return int|null
     */
    public function getAddon_priority()
    {
        return $this->addon_priority;
    }
    /**
     * Set addon_priority value
     * @param int $addon_priority
     * @return \StructType\ProductInfo
     */
    public function setAddon_priority($addon_priority = null)
    {
        // validation for constraint: int
        if (!is_null($addon_priority) && !is_numeric($addon_priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($addon_priority)), __LINE__);
        }
        $this->addon_priority = $addon_priority;
        return $this;
    }
    /**
     * Get service_flag_locks value
     * @return string|null
     */
    public function getService_flag_locks()
    {
        return $this->service_flag_locks;
    }
    /**
     * Set service_flag_locks value
     * @param string $service_flag_locks
     * @return \StructType\ProductInfo
     */
    public function setService_flag_locks($service_flag_locks = null)
    {
        // validation for constraint: string
        if (!is_null($service_flag_locks) && !is_string($service_flag_locks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($service_flag_locks)), __LINE__);
        }
        $this->service_flag_locks = $service_flag_locks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
