<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceListInfo StructType
 * @subpackage Structs
 */
class PriceListInfo extends AbstractStructBase
{
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $product;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $price;
    /**
     * Constructor method for PriceListInfo
     * @uses PriceListInfo::setProduct()
     * @uses PriceListInfo::setPrice()
     * @param string $product
     * @param string $price
     */
    public function __construct($product = null, $price = null)
    {
        $this
            ->setProduct($product)
            ->setPrice($price);
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\PriceListInfo
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get price value
     * @return string
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param string $price
     * @return \StructType\PriceListInfo
     */
    public function setPrice($price = null)
    {
        // validation for constraint: string
        if (!is_null($price) && !is_string($price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceListInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
