<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PeriodicalPaymentInfo StructType
 * @subpackage Structs
 */
class PeriodicalPaymentInfo extends AbstractStructBase
{
    /**
     * The i_periodical_payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_periodical_payment;
    /**
     * The i_object
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_object;
    /**
     * The i_periodical_payment_period
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_periodical_payment_period;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The balance_threshold
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance_threshold;
    /**
     * The from_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $from_date;
    /**
     * The to_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $to_date;
    /**
     * The discontinued
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discontinued;
    /**
     * The stamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $stamp;
    /**
     * The last_payment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $last_payment;
    /**
     * The frozen
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $frozen;
    /**
     * The object
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $object;
    /**
     * Constructor method for PeriodicalPaymentInfo
     * @uses PeriodicalPaymentInfo::setI_periodical_payment()
     * @uses PeriodicalPaymentInfo::setI_object()
     * @uses PeriodicalPaymentInfo::setI_periodical_payment_period()
     * @uses PeriodicalPaymentInfo::setAmount()
     * @uses PeriodicalPaymentInfo::setBalance_threshold()
     * @uses PeriodicalPaymentInfo::setFrom_date()
     * @uses PeriodicalPaymentInfo::setTo_date()
     * @uses PeriodicalPaymentInfo::setDiscontinued()
     * @uses PeriodicalPaymentInfo::setStamp()
     * @uses PeriodicalPaymentInfo::setLast_payment()
     * @uses PeriodicalPaymentInfo::setFrozen()
     * @uses PeriodicalPaymentInfo::setObject()
     * @param int $i_periodical_payment
     * @param int $i_object
     * @param int $i_periodical_payment_period
     * @param float $amount
     * @param float $balance_threshold
     * @param string $from_date
     * @param string $to_date
     * @param string $discontinued
     * @param string $stamp
     * @param string $last_payment
     * @param string $frozen
     * @param string $object
     */
    public function __construct($i_periodical_payment = null, $i_object = null, $i_periodical_payment_period = null, $amount = null, $balance_threshold = null, $from_date = null, $to_date = null, $discontinued = null, $stamp = null, $last_payment = null, $frozen = null, $object = null)
    {
        $this
            ->setI_periodical_payment($i_periodical_payment)
            ->setI_object($i_object)
            ->setI_periodical_payment_period($i_periodical_payment_period)
            ->setAmount($amount)
            ->setBalance_threshold($balance_threshold)
            ->setFrom_date($from_date)
            ->setTo_date($to_date)
            ->setDiscontinued($discontinued)
            ->setStamp($stamp)
            ->setLast_payment($last_payment)
            ->setFrozen($frozen)
            ->setObject($object);
    }
    /**
     * Get i_periodical_payment value
     * @return int|null
     */
    public function getI_periodical_payment()
    {
        return $this->i_periodical_payment;
    }
    /**
     * Set i_periodical_payment value
     * @param int $i_periodical_payment
     * @return \StructType\PeriodicalPaymentInfo
     */
    public function setI_periodical_payment($i_periodical_payment = null)
    {
        // validation for constraint: int
        if (!is_null($i_periodical_payment) && !is_numeric($i_periodical_payment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_periodical_payment)), __LINE__);
        }
        $this->i_periodical_payment = $i_periodical_payment;
        return $this;
    }
    /**
     * Get i_object value
     * @return int|null
     */
    public function getI_object()
    {
        return $this->i_object;
    }
    /**
     * Set i_object value
     * @param int $i_object
     * @return \StructType\PeriodicalPaymentInfo
     */
    public function setI_object($i_object = null)
    {
        // validation for constraint: int
        if (!is_null($i_object) && !is_numeric($i_object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_object)), __LINE__);
        }
        $this->i_object = $i_object;
        return $this;
    }
    /**
     * Get i_periodical_payment_period value
     * @return int|null
     */
    public function getI_periodical_payment_period()
    {
        return $this->i_periodical_payment_period;
    }
    /**
     * Set i_periodical_payment_period value
     * @param int $i_periodical_payment_period
     * @return \StructType\PeriodicalPaymentInfo
     */
    public function setI_periodical_payment_period($i_periodical_payment_period = null)
    {
        // validation for constraint: int
        if (!is_null($i_periodical_payment_period) && !is_numeric($i_periodical_payment_period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_periodical_payment_period)), __LINE__);
        }
        $this->i_periodical_payment_period = $i_periodical_payment_period;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\PeriodicalPaymentInfo
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get balance_threshold value
     * @return float|null
     */
    public function getBalance_threshold()
    {
        return $this->balance_threshold;
    }
    /**
     * Set balance_threshold value
     * @param float $balance_threshold
     * @return \StructType\PeriodicalPaymentInfo
     */
    public function setBalance_threshold($balance_threshold = null)
    {
        $this->balance_threshold = $balance_threshold;
        return $this;
    }
    /**
     * Get from_date value
     * @return string|null
     */
    public function getFrom_date()
    {
        return $this->from_date;
    }
    /**
     * Set from_date value
     * @param string $from_date
     * @return \StructType\PeriodicalPaymentInfo
     */
    public function setFrom_date($from_date = null)
    {
        // validation for constraint: string
        if (!is_null($from_date) && !is_string($from_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from_date)), __LINE__);
        }
        $this->from_date = $from_date;
        return $this;
    }
    /**
     * Get to_date value
     * @return string|null
     */
    public function getTo_date()
    {
        return $this->to_date;
    }
    /**
     * Set to_date value
     * @param string $to_date
     * @return \StructType\PeriodicalPaymentInfo
     */
    public function setTo_date($to_date = null)
    {
        // validation for constraint: string
        if (!is_null($to_date) && !is_string($to_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to_date)), __LINE__);
        }
        $this->to_date = $to_date;
        return $this;
    }
    /**
     * Get discontinued value
     * @return string|null
     */
    public function getDiscontinued()
    {
        return $this->discontinued;
    }
    /**
     * Set discontinued value
     * @param string $discontinued
     * @return \StructType\PeriodicalPaymentInfo
     */
    public function setDiscontinued($discontinued = null)
    {
        // validation for constraint: string
        if (!is_null($discontinued) && !is_string($discontinued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discontinued)), __LINE__);
        }
        $this->discontinued = $discontinued;
        return $this;
    }
    /**
     * Get stamp value
     * @return string|null
     */
    public function getStamp()
    {
        return $this->stamp;
    }
    /**
     * Set stamp value
     * @param string $stamp
     * @return \StructType\PeriodicalPaymentInfo
     */
    public function setStamp($stamp = null)
    {
        // validation for constraint: string
        if (!is_null($stamp) && !is_string($stamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stamp)), __LINE__);
        }
        $this->stamp = $stamp;
        return $this;
    }
    /**
     * Get last_payment value
     * @return string|null
     */
    public function getLast_payment()
    {
        return $this->last_payment;
    }
    /**
     * Set last_payment value
     * @param string $last_payment
     * @return \StructType\PeriodicalPaymentInfo
     */
    public function setLast_payment($last_payment = null)
    {
        // validation for constraint: string
        if (!is_null($last_payment) && !is_string($last_payment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_payment)), __LINE__);
        }
        $this->last_payment = $last_payment;
        return $this;
    }
    /**
     * Get frozen value
     * @return string|null
     */
    public function getFrozen()
    {
        return $this->frozen;
    }
    /**
     * Set frozen value
     * @param string $frozen
     * @return \StructType\PeriodicalPaymentInfo
     */
    public function setFrozen($frozen = null)
    {
        // validation for constraint: string
        if (!is_null($frozen) && !is_string($frozen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($frozen)), __LINE__);
        }
        $this->frozen = $frozen;
        return $this;
    }
    /**
     * Get object value
     * @return string|null
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * Set object value
     * @param string $object
     * @return \StructType\PeriodicalPaymentInfo
     */
    public function setObject($object = null)
    {
        // validation for constraint: string
        if (!is_null($object) && !is_string($object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($object)), __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PeriodicalPaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
