<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethodInfo StructType
 * @subpackage Structs
 */
class PaymentMethodInfo extends AbstractStructBase
{
    /**
     * The payment_method
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $payment_method;
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The zip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zip;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The exp_date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $exp_date;
    /**
     * The start_date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $start_date;
    /**
     * The cvv
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cvv;
    /**
     * The issue_no
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $issue_no;
    /**
     * The account_number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $account_number;
    /**
     * The bank_number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bank_number;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $city;
    /**
     * The iso_3166_1_a2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $iso_3166_1_a2;
    /**
     * The i_country_subdivision
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_country_subdivision;
    /**
     * The phone_number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phone_number;
    /**
     * The refnum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $refnum;
    /**
     * Constructor method for PaymentMethodInfo
     * @uses PaymentMethodInfo::setPayment_method()
     * @uses PaymentMethodInfo::setNumber()
     * @uses PaymentMethodInfo::setName()
     * @uses PaymentMethodInfo::setZip()
     * @uses PaymentMethodInfo::setAddress()
     * @uses PaymentMethodInfo::setExp_date()
     * @uses PaymentMethodInfo::setStart_date()
     * @uses PaymentMethodInfo::setCvv()
     * @uses PaymentMethodInfo::setIssue_no()
     * @uses PaymentMethodInfo::setAccount_number()
     * @uses PaymentMethodInfo::setBank_number()
     * @uses PaymentMethodInfo::setCity()
     * @uses PaymentMethodInfo::setIso_3166_1_a2()
     * @uses PaymentMethodInfo::setI_country_subdivision()
     * @uses PaymentMethodInfo::setPhone_number()
     * @uses PaymentMethodInfo::setRefnum()
     * @param string $payment_method
     * @param string $number
     * @param string $name
     * @param string $zip
     * @param string $address
     * @param string $exp_date
     * @param string $start_date
     * @param string $cvv
     * @param string $issue_no
     * @param string $account_number
     * @param string $bank_number
     * @param string $city
     * @param string $iso_3166_1_a2
     * @param int $i_country_subdivision
     * @param string $phone_number
     * @param string $refnum
     */
    public function __construct($payment_method = null, $number = null, $name = null, $zip = null, $address = null, $exp_date = null, $start_date = null, $cvv = null, $issue_no = null, $account_number = null, $bank_number = null, $city = null, $iso_3166_1_a2 = null, $i_country_subdivision = null, $phone_number = null, $refnum = null)
    {
        $this
            ->setPayment_method($payment_method)
            ->setNumber($number)
            ->setName($name)
            ->setZip($zip)
            ->setAddress($address)
            ->setExp_date($exp_date)
            ->setStart_date($start_date)
            ->setCvv($cvv)
            ->setIssue_no($issue_no)
            ->setAccount_number($account_number)
            ->setBank_number($bank_number)
            ->setCity($city)
            ->setIso_3166_1_a2($iso_3166_1_a2)
            ->setI_country_subdivision($i_country_subdivision)
            ->setPhone_number($phone_number)
            ->setRefnum($refnum);
    }
    /**
     * Get payment_method value
     * @return string
     */
    public function getPayment_method()
    {
        return $this->payment_method;
    }
    /**
     * Set payment_method value
     * @param string $payment_method
     * @return \StructType\PaymentMethodInfo
     */
    public function setPayment_method($payment_method = null)
    {
        // validation for constraint: string
        if (!is_null($payment_method) && !is_string($payment_method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payment_method)), __LINE__);
        }
        $this->payment_method = $payment_method;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\PaymentMethodInfo
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\PaymentMethodInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \StructType\PaymentMethodInfo
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\PaymentMethodInfo
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get exp_date value
     * @return string|null
     */
    public function getExp_date()
    {
        return $this->exp_date;
    }
    /**
     * Set exp_date value
     * @param string $exp_date
     * @return \StructType\PaymentMethodInfo
     */
    public function setExp_date($exp_date = null)
    {
        // validation for constraint: string
        if (!is_null($exp_date) && !is_string($exp_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exp_date)), __LINE__);
        }
        $this->exp_date = $exp_date;
        return $this;
    }
    /**
     * Get start_date value
     * @return string|null
     */
    public function getStart_date()
    {
        return $this->start_date;
    }
    /**
     * Set start_date value
     * @param string $start_date
     * @return \StructType\PaymentMethodInfo
     */
    public function setStart_date($start_date = null)
    {
        // validation for constraint: string
        if (!is_null($start_date) && !is_string($start_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start_date)), __LINE__);
        }
        $this->start_date = $start_date;
        return $this;
    }
    /**
     * Get cvv value
     * @return string|null
     */
    public function getCvv()
    {
        return $this->cvv;
    }
    /**
     * Set cvv value
     * @param string $cvv
     * @return \StructType\PaymentMethodInfo
     */
    public function setCvv($cvv = null)
    {
        // validation for constraint: string
        if (!is_null($cvv) && !is_string($cvv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cvv)), __LINE__);
        }
        $this->cvv = $cvv;
        return $this;
    }
    /**
     * Get issue_no value
     * @return string|null
     */
    public function getIssue_no()
    {
        return $this->issue_no;
    }
    /**
     * Set issue_no value
     * @param string $issue_no
     * @return \StructType\PaymentMethodInfo
     */
    public function setIssue_no($issue_no = null)
    {
        // validation for constraint: string
        if (!is_null($issue_no) && !is_string($issue_no)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issue_no)), __LINE__);
        }
        $this->issue_no = $issue_no;
        return $this;
    }
    /**
     * Get account_number value
     * @return string|null
     */
    public function getAccount_number()
    {
        return $this->account_number;
    }
    /**
     * Set account_number value
     * @param string $account_number
     * @return \StructType\PaymentMethodInfo
     */
    public function setAccount_number($account_number = null)
    {
        // validation for constraint: string
        if (!is_null($account_number) && !is_string($account_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($account_number)), __LINE__);
        }
        $this->account_number = $account_number;
        return $this;
    }
    /**
     * Get bank_number value
     * @return string|null
     */
    public function getBank_number()
    {
        return $this->bank_number;
    }
    /**
     * Set bank_number value
     * @param string $bank_number
     * @return \StructType\PaymentMethodInfo
     */
    public function setBank_number($bank_number = null)
    {
        // validation for constraint: string
        if (!is_null($bank_number) && !is_string($bank_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bank_number)), __LINE__);
        }
        $this->bank_number = $bank_number;
        return $this;
    }
    /**
     * Get city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->city) ? $this->city : null;
    }
    /**
     * Set city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\PaymentMethodInfo
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->city);
        } else {
            $this->city = $city;
        }
        return $this;
    }
    /**
     * Get iso_3166_1_a2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIso_3166_1_a2()
    {
        return isset($this->iso_3166_1_a2) ? $this->iso_3166_1_a2 : null;
    }
    /**
     * Set iso_3166_1_a2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iso_3166_1_a2
     * @return \StructType\PaymentMethodInfo
     */
    public function setIso_3166_1_a2($iso_3166_1_a2 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_3166_1_a2) && !is_string($iso_3166_1_a2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_3166_1_a2)), __LINE__);
        }
        if (is_null($iso_3166_1_a2) || (is_array($iso_3166_1_a2) && empty($iso_3166_1_a2))) {
            unset($this->iso_3166_1_a2);
        } else {
            $this->iso_3166_1_a2 = $iso_3166_1_a2;
        }
        return $this;
    }
    /**
     * Get i_country_subdivision value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_country_subdivision()
    {
        return isset($this->i_country_subdivision) ? $this->i_country_subdivision : null;
    }
    /**
     * Set i_country_subdivision value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_country_subdivision
     * @return \StructType\PaymentMethodInfo
     */
    public function setI_country_subdivision($i_country_subdivision = null)
    {
        // validation for constraint: int
        if (!is_null($i_country_subdivision) && !is_numeric($i_country_subdivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_country_subdivision)), __LINE__);
        }
        if (is_null($i_country_subdivision) || (is_array($i_country_subdivision) && empty($i_country_subdivision))) {
            unset($this->i_country_subdivision);
        } else {
            $this->i_country_subdivision = $i_country_subdivision;
        }
        return $this;
    }
    /**
     * Get phone_number value
     * @return string|null
     */
    public function getPhone_number()
    {
        return $this->phone_number;
    }
    /**
     * Set phone_number value
     * @param string $phone_number
     * @return \StructType\PaymentMethodInfo
     */
    public function setPhone_number($phone_number = null)
    {
        // validation for constraint: string
        if (!is_null($phone_number) && !is_string($phone_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone_number)), __LINE__);
        }
        $this->phone_number = $phone_number;
        return $this;
    }
    /**
     * Get refnum value
     * @return string|null
     */
    public function getRefnum()
    {
        return $this->refnum;
    }
    /**
     * Set refnum value
     * @param string $refnum
     * @return \StructType\PaymentMethodInfo
     */
    public function setRefnum($refnum = null)
    {
        // validation for constraint: string
        if (!is_null($refnum) && !is_string($refnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refnum)), __LINE__);
        }
        $this->refnum = $refnum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentMethodInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
