<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MoveAccountResponse StructType
 * @subpackage Structs
 */
class MoveAccountResponse extends AbstractStructBase
{
    /**
     * The old_i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $old_i_account;
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $warnings;
    /**
     * Constructor method for MoveAccountResponse
     * @uses MoveAccountResponse::setOld_i_account()
     * @uses MoveAccountResponse::setI_account()
     * @uses MoveAccountResponse::setWarnings()
     * @param int $old_i_account
     * @param int $i_account
     * @param string[] $warnings
     */
    public function __construct($old_i_account = null, $i_account = null, array $warnings = array())
    {
        $this
            ->setOld_i_account($old_i_account)
            ->setI_account($i_account)
            ->setWarnings($warnings);
    }
    /**
     * Get old_i_account value
     * @return int
     */
    public function getOld_i_account()
    {
        return $this->old_i_account;
    }
    /**
     * Set old_i_account value
     * @param int $old_i_account
     * @return \StructType\MoveAccountResponse
     */
    public function setOld_i_account($old_i_account = null)
    {
        // validation for constraint: int
        if (!is_null($old_i_account) && !is_numeric($old_i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($old_i_account)), __LINE__);
        }
        $this->old_i_account = $old_i_account;
        return $this;
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\MoveAccountResponse
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get warnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getWarnings()
    {
        return isset($this->warnings) ? $this->warnings : null;
    }
    /**
     * Set warnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $warnings
     * @return \StructType\MoveAccountResponse
     */
    public function setWarnings(array $warnings = array())
    {
        foreach ($warnings as $moveAccountResponseWarningsItem) {
            // validation for constraint: itemType
            if (!is_string($moveAccountResponseWarningsItem)) {
                throw new \InvalidArgumentException(sprintf('The warnings property can only contain items of string, "%s" given', is_object($moveAccountResponseWarningsItem) ? get_class($moveAccountResponseWarningsItem) : gettype($moveAccountResponseWarningsItem)), __LINE__);
            }
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->warnings);
        } else {
            $this->warnings = $warnings;
        }
        return $this;
    }
    /**
     * Add item to warnings value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MoveAccountResponse
     */
    public function addToWarnings($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The warnings property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->warnings[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MoveAccountResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
