<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeTransferRequest StructType
 * @subpackage Structs
 */
class MakeTransferRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $destination;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $product;
    /**
     * The output_currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $output_currency;
    /**
     * The operator_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $operator_id;
    /**
     * Constructor method for MakeTransferRequest
     * @uses MakeTransferRequest::setI_account()
     * @uses MakeTransferRequest::setDestination()
     * @uses MakeTransferRequest::setProduct()
     * @uses MakeTransferRequest::setOutput_currency()
     * @uses MakeTransferRequest::setOperator_id()
     * @param int $i_account
     * @param string $destination
     * @param string $product
     * @param string $output_currency
     * @param int $operator_id
     */
    public function __construct($i_account = null, $destination = null, $product = null, $output_currency = null, $operator_id = null)
    {
        $this
            ->setI_account($i_account)
            ->setDestination($destination)
            ->setProduct($product)
            ->setOutput_currency($output_currency)
            ->setOperator_id($operator_id);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\MakeTransferRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get destination value
     * @return string
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\MakeTransferRequest
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\MakeTransferRequest
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get output_currency value
     * @return string
     */
    public function getOutput_currency()
    {
        return $this->output_currency;
    }
    /**
     * Set output_currency value
     * @param string $output_currency
     * @return \StructType\MakeTransferRequest
     */
    public function setOutput_currency($output_currency = null)
    {
        // validation for constraint: string
        if (!is_null($output_currency) && !is_string($output_currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($output_currency)), __LINE__);
        }
        $this->output_currency = $output_currency;
        return $this;
    }
    /**
     * Get operator_id value
     * @return int|null
     */
    public function getOperator_id()
    {
        return $this->operator_id;
    }
    /**
     * Set operator_id value
     * @param int $operator_id
     * @return \StructType\MakeTransferRequest
     */
    public function setOperator_id($operator_id = null)
    {
        // validation for constraint: int
        if (!is_null($operator_id) && !is_numeric($operator_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($operator_id)), __LINE__);
        }
        $this->operator_id = $operator_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MakeTransferRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
