<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MOHInfo StructType
 * @subpackage Structs
 */
class MOHInfo extends AbstractStructBase
{
    /**
     * The i_moh
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_moh;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The converted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $converted;
    /**
     * The tries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tries;
    /**
     * Constructor method for MOHInfo
     * @uses MOHInfo::setI_moh()
     * @uses MOHInfo::setName()
     * @uses MOHInfo::setConverted()
     * @uses MOHInfo::setTries()
     * @param int $i_moh
     * @param string $name
     * @param string $converted
     * @param int $tries
     */
    public function __construct($i_moh = null, $name = null, $converted = null, $tries = null)
    {
        $this
            ->setI_moh($i_moh)
            ->setName($name)
            ->setConverted($converted)
            ->setTries($tries);
    }
    /**
     * Get i_moh value
     * @return int|null
     */
    public function getI_moh()
    {
        return $this->i_moh;
    }
    /**
     * Set i_moh value
     * @param int $i_moh
     * @return \StructType\MOHInfo
     */
    public function setI_moh($i_moh = null)
    {
        // validation for constraint: int
        if (!is_null($i_moh) && !is_numeric($i_moh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_moh)), __LINE__);
        }
        $this->i_moh = $i_moh;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\MOHInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get converted value
     * @return string|null
     */
    public function getConverted()
    {
        return $this->converted;
    }
    /**
     * Set converted value
     * @param string $converted
     * @return \StructType\MOHInfo
     */
    public function setConverted($converted = null)
    {
        // validation for constraint: string
        if (!is_null($converted) && !is_string($converted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($converted)), __LINE__);
        }
        $this->converted = $converted;
        return $this;
    }
    /**
     * Get tries value
     * @return int|null
     */
    public function getTries()
    {
        return $this->tries;
    }
    /**
     * Set tries value
     * @param int $tries
     * @return \StructType\MOHInfo
     */
    public function setTries($tries = null)
    {
        // validation for constraint: int
        if (!is_null($tries) && !is_numeric($tries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tries)), __LINE__);
        }
        $this->tries = $tries;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MOHInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
