<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetXrateListResponse StructType
 * @subpackage Structs
 */
class GetXrateListResponse extends AbstractStructBase
{
    /**
     * The exchange_rate_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:XrateInfo[]
     * - ref: soapenc:arrayType
     * @var XrateInfo
     */
    public $exchange_rate_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetXrateListResponse
     * @uses GetXrateListResponse::setExchange_rate_list()
     * @uses GetXrateListResponse::setTotal()
     * @param XrateInfo $exchange_rate_list
     * @param int $total
     */
    public function __construct(XrateInfo $exchange_rate_list = null, $total = null)
    {
        $this
            ->setExchange_rate_list($exchange_rate_list)
            ->setTotal($total);
    }
    /**
     * Get exchange_rate_list value
     * @return XrateInfo|null
     */
    public function getExchange_rate_list()
    {
        return $this->exchange_rate_list;
    }
    /**
     * Set exchange_rate_list value
     * @param XrateInfo $exchange_rate_list
     * @return \StructType\GetXrateListResponse
     */
    public function setExchange_rate_list(XrateInfo $exchange_rate_list = null)
    {
        $this->exchange_rate_list = $exchange_rate_list;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetXrateListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetXrateListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
