<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTransferInfoRequest StructType
 * @subpackage Structs
 */
class GetTransferInfoRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The transaction_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $transaction_id;
    /**
     * Constructor method for GetTransferInfoRequest
     * @uses GetTransferInfoRequest::setI_account()
     * @uses GetTransferInfoRequest::setTransaction_id()
     * @param int $i_account
     * @param int $transaction_id
     */
    public function __construct($i_account = null, $transaction_id = null)
    {
        $this
            ->setI_account($i_account)
            ->setTransaction_id($transaction_id);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\GetTransferInfoRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get transaction_id value
     * @return int
     */
    public function getTransaction_id()
    {
        return $this->transaction_id;
    }
    /**
     * Set transaction_id value
     * @param int $transaction_id
     * @return \StructType\GetTransferInfoRequest
     */
    public function setTransaction_id($transaction_id = null)
    {
        // validation for constraint: int
        if (!is_null($transaction_id) && !is_numeric($transaction_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transaction_id)), __LINE__);
        }
        $this->transaction_id = $transaction_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetTransferInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
