<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTransactionsTotalInfoResponse StructType
 * @subpackage Structs
 */
class GetTransactionsTotalInfoResponse extends AbstractStructBase
{
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $count;
    /**
     * The sessions_count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sessions_count;
    /**
     * The total_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $total_amount;
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iso_4217;
    /**
     * The total_info
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:TotalTransInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\TotalTransInfo[]
     */
    public $total_info;
    /**
     * The per_service_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:PerServiceInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\PerServiceInfo[]
     */
    public $per_service_info;
    /**
     * Constructor method for GetTransactionsTotalInfoResponse
     * @uses GetTransactionsTotalInfoResponse::setCount()
     * @uses GetTransactionsTotalInfoResponse::setSessions_count()
     * @uses GetTransactionsTotalInfoResponse::setTotal_amount()
     * @uses GetTransactionsTotalInfoResponse::setIso_4217()
     * @uses GetTransactionsTotalInfoResponse::setTotal_info()
     * @uses GetTransactionsTotalInfoResponse::setPer_service_info()
     * @param int $count
     * @param int $sessions_count
     * @param int $total_amount
     * @param string $iso_4217
     * @param \StructType\TotalTransInfo[] $total_info
     * @param \StructType\PerServiceInfo[] $per_service_info
     */
    public function __construct($count = null, $sessions_count = null, $total_amount = null, $iso_4217 = null, array $total_info = array(), array $per_service_info = array())
    {
        $this
            ->setCount($count)
            ->setSessions_count($sessions_count)
            ->setTotal_amount($total_amount)
            ->setIso_4217($iso_4217)
            ->setTotal_info($total_info)
            ->setPer_service_info($per_service_info);
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\GetTransactionsTotalInfoResponse
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get sessions_count value
     * @return int|null
     */
    public function getSessions_count()
    {
        return $this->sessions_count;
    }
    /**
     * Set sessions_count value
     * @param int $sessions_count
     * @return \StructType\GetTransactionsTotalInfoResponse
     */
    public function setSessions_count($sessions_count = null)
    {
        // validation for constraint: int
        if (!is_null($sessions_count) && !is_numeric($sessions_count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sessions_count)), __LINE__);
        }
        $this->sessions_count = $sessions_count;
        return $this;
    }
    /**
     * Get total_amount value
     * @return int|null
     */
    public function getTotal_amount()
    {
        return $this->total_amount;
    }
    /**
     * Set total_amount value
     * @param int $total_amount
     * @return \StructType\GetTransactionsTotalInfoResponse
     */
    public function setTotal_amount($total_amount = null)
    {
        // validation for constraint: int
        if (!is_null($total_amount) && !is_numeric($total_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total_amount)), __LINE__);
        }
        $this->total_amount = $total_amount;
        return $this;
    }
    /**
     * Get iso_4217 value
     * @return string|null
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\GetTransactionsTotalInfoResponse
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Get total_info value
     * @return \StructType\TotalTransInfo[]|null
     */
    public function getTotal_info()
    {
        return $this->total_info;
    }
    /**
     * Set total_info value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalTransInfo[] $total_info
     * @return \StructType\GetTransactionsTotalInfoResponse
     */
    public function setTotal_info(array $total_info = array())
    {
        foreach ($total_info as $getTransactionsTotalInfoResponseTotal_infoItem) {
            // validation for constraint: itemType
            if (!$getTransactionsTotalInfoResponseTotal_infoItem instanceof \StructType\TotalTransInfo) {
                throw new \InvalidArgumentException(sprintf('The total_info property can only contain items of \StructType\TotalTransInfo, "%s" given', is_object($getTransactionsTotalInfoResponseTotal_infoItem) ? get_class($getTransactionsTotalInfoResponseTotal_infoItem) : gettype($getTransactionsTotalInfoResponseTotal_infoItem)), __LINE__);
            }
        }
        $this->total_info = $total_info;
        return $this;
    }
    /**
     * Add item to total_info value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalTransInfo $item
     * @return \StructType\GetTransactionsTotalInfoResponse
     */
    public function addToTotal_info(\StructType\TotalTransInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TotalTransInfo) {
            throw new \InvalidArgumentException(sprintf('The total_info property can only contain items of \StructType\TotalTransInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->total_info[] = $item;
        return $this;
    }
    /**
     * Get per_service_info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PerServiceInfo[]|null
     */
    public function getPer_service_info()
    {
        return isset($this->per_service_info) ? $this->per_service_info : null;
    }
    /**
     * Set per_service_info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PerServiceInfo[] $per_service_info
     * @return \StructType\GetTransactionsTotalInfoResponse
     */
    public function setPer_service_info(array $per_service_info = array())
    {
        foreach ($per_service_info as $getTransactionsTotalInfoResponsePer_service_infoItem) {
            // validation for constraint: itemType
            if (!$getTransactionsTotalInfoResponsePer_service_infoItem instanceof \StructType\PerServiceInfo) {
                throw new \InvalidArgumentException(sprintf('The per_service_info property can only contain items of \StructType\PerServiceInfo, "%s" given', is_object($getTransactionsTotalInfoResponsePer_service_infoItem) ? get_class($getTransactionsTotalInfoResponsePer_service_infoItem) : gettype($getTransactionsTotalInfoResponsePer_service_infoItem)), __LINE__);
            }
        }
        if (is_null($per_service_info) || (is_array($per_service_info) && empty($per_service_info))) {
            unset($this->per_service_info);
        } else {
            $this->per_service_info = $per_service_info;
        }
        return $this;
    }
    /**
     * Add item to per_service_info value
     * @throws \InvalidArgumentException
     * @param \StructType\PerServiceInfo $item
     * @return \StructType\GetTransactionsTotalInfoResponse
     */
    public function addToPer_service_info(\StructType\PerServiceInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PerServiceInfo) {
            throw new \InvalidArgumentException(sprintf('The per_service_info property can only contain items of \StructType\PerServiceInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->per_service_info[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetTransactionsTotalInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
