<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRepresentativeListResponse StructType
 * @subpackage Structs
 */
class GetRepresentativeListResponse extends AbstractStructBase
{
    /**
     * The representative_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:RepresentativeInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\RepresentativeInfo[]
     */
    public $representative_list;
    /**
     * Constructor method for GetRepresentativeListResponse
     * @uses GetRepresentativeListResponse::setRepresentative_list()
     * @param \StructType\RepresentativeInfo[] $representative_list
     */
    public function __construct(array $representative_list = array())
    {
        $this
            ->setRepresentative_list($representative_list);
    }
    /**
     * Get representative_list value
     * @return \StructType\RepresentativeInfo[]|null
     */
    public function getRepresentative_list()
    {
        return $this->representative_list;
    }
    /**
     * Set representative_list value
     * @throws \InvalidArgumentException
     * @param \StructType\RepresentativeInfo[] $representative_list
     * @return \StructType\GetRepresentativeListResponse
     */
    public function setRepresentative_list(array $representative_list = array())
    {
        foreach ($representative_list as $getRepresentativeListResponseRepresentative_listItem) {
            // validation for constraint: itemType
            if (!$getRepresentativeListResponseRepresentative_listItem instanceof \StructType\RepresentativeInfo) {
                throw new \InvalidArgumentException(sprintf('The representative_list property can only contain items of \StructType\RepresentativeInfo, "%s" given', is_object($getRepresentativeListResponseRepresentative_listItem) ? get_class($getRepresentativeListResponseRepresentative_listItem) : gettype($getRepresentativeListResponseRepresentative_listItem)), __LINE__);
            }
        }
        $this->representative_list = $representative_list;
        return $this;
    }
    /**
     * Add item to representative_list value
     * @throws \InvalidArgumentException
     * @param \StructType\RepresentativeInfo $item
     * @return \StructType\GetRepresentativeListResponse
     */
    public function addToRepresentative_list(\StructType\RepresentativeInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RepresentativeInfo) {
            throw new \InvalidArgumentException(sprintf('The representative_list property can only contain items of \StructType\RepresentativeInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->representative_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRepresentativeListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
