<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoiceListResponse StructType
 * @subpackage Structs
 */
class GetInvoiceListResponse extends AbstractStructBase
{
    /**
     * The invoice_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:InvoiceInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\InvoiceInfo[]
     */
    public $invoice_list;
    /**
     * Constructor method for GetInvoiceListResponse
     * @uses GetInvoiceListResponse::setInvoice_list()
     * @param \StructType\InvoiceInfo[] $invoice_list
     */
    public function __construct(array $invoice_list = array())
    {
        $this
            ->setInvoice_list($invoice_list);
    }
    /**
     * Get invoice_list value
     * @return \StructType\InvoiceInfo[]|null
     */
    public function getInvoice_list()
    {
        return $this->invoice_list;
    }
    /**
     * Set invoice_list value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceInfo[] $invoice_list
     * @return \StructType\GetInvoiceListResponse
     */
    public function setInvoice_list(array $invoice_list = array())
    {
        foreach ($invoice_list as $getInvoiceListResponseInvoice_listItem) {
            // validation for constraint: itemType
            if (!$getInvoiceListResponseInvoice_listItem instanceof \StructType\InvoiceInfo) {
                throw new \InvalidArgumentException(sprintf('The invoice_list property can only contain items of \StructType\InvoiceInfo, "%s" given', is_object($getInvoiceListResponseInvoice_listItem) ? get_class($getInvoiceListResponseInvoice_listItem) : gettype($getInvoiceListResponseInvoice_listItem)), __LINE__);
            }
        }
        $this->invoice_list = $invoice_list;
        return $this;
    }
    /**
     * Add item to invoice_list value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceInfo $item
     * @return \StructType\GetInvoiceListResponse
     */
    public function addToInvoice_list(\StructType\InvoiceInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceInfo) {
            throw new \InvalidArgumentException(sprintf('The invoice_list property can only contain items of \StructType\InvoiceInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->invoice_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInvoiceListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
