<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoiceInfoRequest StructType
 * @subpackage Structs
 */
class GetInvoiceInfoRequest extends AbstractStructBase
{
    /**
     * The i_invoice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_invoice;
    /**
     * The invoice_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $invoice_number;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The get_pdf
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $get_pdf;
    /**
     * Constructor method for GetInvoiceInfoRequest
     * @uses GetInvoiceInfoRequest::setI_invoice()
     * @uses GetInvoiceInfoRequest::setInvoice_number()
     * @uses GetInvoiceInfoRequest::setI_customer()
     * @uses GetInvoiceInfoRequest::setGet_pdf()
     * @param int $i_invoice
     * @param int $invoice_number
     * @param int $i_customer
     * @param int $get_pdf
     */
    public function __construct($i_invoice = null, $invoice_number = null, $i_customer = null, $get_pdf = null)
    {
        $this
            ->setI_invoice($i_invoice)
            ->setInvoice_number($invoice_number)
            ->setI_customer($i_customer)
            ->setGet_pdf($get_pdf);
    }
    /**
     * Get i_invoice value
     * @return int|null
     */
    public function getI_invoice()
    {
        return $this->i_invoice;
    }
    /**
     * Set i_invoice value
     * @param int $i_invoice
     * @return \StructType\GetInvoiceInfoRequest
     */
    public function setI_invoice($i_invoice = null)
    {
        // validation for constraint: int
        if (!is_null($i_invoice) && !is_numeric($i_invoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_invoice)), __LINE__);
        }
        $this->i_invoice = $i_invoice;
        return $this;
    }
    /**
     * Get invoice_number value
     * @return int|null
     */
    public function getInvoice_number()
    {
        return $this->invoice_number;
    }
    /**
     * Set invoice_number value
     * @param int $invoice_number
     * @return \StructType\GetInvoiceInfoRequest
     */
    public function setInvoice_number($invoice_number = null)
    {
        // validation for constraint: int
        if (!is_null($invoice_number) && !is_numeric($invoice_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoice_number)), __LINE__);
        }
        $this->invoice_number = $invoice_number;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\GetInvoiceInfoRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get get_pdf value
     * @return int|null
     */
    public function getGet_pdf()
    {
        return $this->get_pdf;
    }
    /**
     * Set get_pdf value
     * @param int $get_pdf
     * @return \StructType\GetInvoiceInfoRequest
     */
    public function setGet_pdf($get_pdf = null)
    {
        // validation for constraint: int
        if (!is_null($get_pdf) && !is_numeric($get_pdf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($get_pdf)), __LINE__);
        }
        $this->get_pdf = $get_pdf;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInvoiceInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
