<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHGListInfoResponse StructType
 * @subpackage Structs
 */
class GetHGListInfoResponse extends AbstractStructBase
{
    /**
     * The huntgroup_list
     * Meta informations extracted from the WSDL
     * - arrayType: pst:HGInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\HGInfo[]
     */
    public $huntgroup_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetHGListInfoResponse
     * @uses GetHGListInfoResponse::setHuntgroup_list()
     * @uses GetHGListInfoResponse::setTotal()
     * @param \StructType\HGInfo[] $huntgroup_list
     * @param int $total
     */
    public function __construct(array $huntgroup_list = array(), $total = null)
    {
        $this
            ->setHuntgroup_list($huntgroup_list)
            ->setTotal($total);
    }
    /**
     * Get huntgroup_list value
     * @return \StructType\HGInfo[]|null
     */
    public function getHuntgroup_list()
    {
        return $this->huntgroup_list;
    }
    /**
     * Set huntgroup_list value
     * @throws \InvalidArgumentException
     * @param \StructType\HGInfo[] $huntgroup_list
     * @return \StructType\GetHGListInfoResponse
     */
    public function setHuntgroup_list(array $huntgroup_list = array())
    {
        foreach ($huntgroup_list as $getHGListInfoResponseHuntgroup_listItem) {
            // validation for constraint: itemType
            if (!$getHGListInfoResponseHuntgroup_listItem instanceof \StructType\HGInfo) {
                throw new \InvalidArgumentException(sprintf('The huntgroup_list property can only contain items of \StructType\HGInfo, "%s" given', is_object($getHGListInfoResponseHuntgroup_listItem) ? get_class($getHGListInfoResponseHuntgroup_listItem) : gettype($getHGListInfoResponseHuntgroup_listItem)), __LINE__);
            }
        }
        $this->huntgroup_list = $huntgroup_list;
        return $this;
    }
    /**
     * Add item to huntgroup_list value
     * @throws \InvalidArgumentException
     * @param \StructType\HGInfo $item
     * @return \StructType\GetHGListInfoResponse
     */
    public function addToHuntgroup_list(\StructType\HGInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HGInfo) {
            throw new \InvalidArgumentException(sprintf('The huntgroup_list property can only contain items of \StructType\HGInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->huntgroup_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotal()
    {
        return isset($this->total) ? $this->total : null;
    }
    /**
     * Set total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $total
     * @return \StructType\GetHGListInfoResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        if (is_null($total) || (is_array($total) && empty($total))) {
            unset($this->total);
        } else {
            $this->total = $total;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetHGListInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
