<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetExtensionsListInfoResponse StructType
 * @subpackage Structs
 */
class GetExtensionsListInfoResponse extends AbstractStructBase
{
    /**
     * The extensions_list
     * Meta informations extracted from the WSDL
     * - arrayType: pst:ExtensionsInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\ExtensionsInfo[]
     */
    public $extensions_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetExtensionsListInfoResponse
     * @uses GetExtensionsListInfoResponse::setExtensions_list()
     * @uses GetExtensionsListInfoResponse::setTotal()
     * @param \StructType\ExtensionsInfo[] $extensions_list
     * @param int $total
     */
    public function __construct(array $extensions_list = array(), $total = null)
    {
        $this
            ->setExtensions_list($extensions_list)
            ->setTotal($total);
    }
    /**
     * Get extensions_list value
     * @return \StructType\ExtensionsInfo[]|null
     */
    public function getExtensions_list()
    {
        return $this->extensions_list;
    }
    /**
     * Set extensions_list value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtensionsInfo[] $extensions_list
     * @return \StructType\GetExtensionsListInfoResponse
     */
    public function setExtensions_list(array $extensions_list = array())
    {
        foreach ($extensions_list as $getExtensionsListInfoResponseExtensions_listItem) {
            // validation for constraint: itemType
            if (!$getExtensionsListInfoResponseExtensions_listItem instanceof \StructType\ExtensionsInfo) {
                throw new \InvalidArgumentException(sprintf('The extensions_list property can only contain items of \StructType\ExtensionsInfo, "%s" given', is_object($getExtensionsListInfoResponseExtensions_listItem) ? get_class($getExtensionsListInfoResponseExtensions_listItem) : gettype($getExtensionsListInfoResponseExtensions_listItem)), __LINE__);
            }
        }
        $this->extensions_list = $extensions_list;
        return $this;
    }
    /**
     * Add item to extensions_list value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtensionsInfo $item
     * @return \StructType\GetExtensionsListInfoResponse
     */
    public function addToExtensions_list(\StructType\ExtensionsInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExtensionsInfo) {
            throw new \InvalidArgumentException(sprintf('The extensions_list property can only contain items of \StructType\ExtensionsInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->extensions_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotal()
    {
        return isset($this->total) ? $this->total : null;
    }
    /**
     * Set total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $total
     * @return \StructType\GetExtensionsListInfoResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        if (is_null($total) || (is_array($total) && empty($total))) {
            unset($this->total);
        } else {
            $this->total = $total;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetExtensionsListInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
