<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDiscountListResponse StructType
 * @subpackage Structs
 */
class GetDiscountListResponse extends AbstractStructBase
{
    /**
     * The discount_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:DiscountInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\DiscountInfo[]
     */
    public $discount_list;
    /**
     * Constructor method for GetDiscountListResponse
     * @uses GetDiscountListResponse::setDiscount_list()
     * @param \StructType\DiscountInfo[] $discount_list
     */
    public function __construct(array $discount_list = array())
    {
        $this
            ->setDiscount_list($discount_list);
    }
    /**
     * Get discount_list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DiscountInfo[]|null
     */
    public function getDiscount_list()
    {
        return isset($this->discount_list) ? $this->discount_list : null;
    }
    /**
     * Set discount_list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountInfo[] $discount_list
     * @return \StructType\GetDiscountListResponse
     */
    public function setDiscount_list(array $discount_list = array())
    {
        foreach ($discount_list as $getDiscountListResponseDiscount_listItem) {
            // validation for constraint: itemType
            if (!$getDiscountListResponseDiscount_listItem instanceof \StructType\DiscountInfo) {
                throw new \InvalidArgumentException(sprintf('The discount_list property can only contain items of \StructType\DiscountInfo, "%s" given', is_object($getDiscountListResponseDiscount_listItem) ? get_class($getDiscountListResponseDiscount_listItem) : gettype($getDiscountListResponseDiscount_listItem)), __LINE__);
            }
        }
        if (is_null($discount_list) || (is_array($discount_list) && empty($discount_list))) {
            unset($this->discount_list);
        } else {
            $this->discount_list = $discount_list;
        }
        return $this;
    }
    /**
     * Add item to discount_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountInfo $item
     * @return \StructType\GetDiscountListResponse
     */
    public function addToDiscount_list(\StructType\DiscountInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiscountInfo) {
            throw new \InvalidArgumentException(sprintf('The discount_list property can only contain items of \StructType\DiscountInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->discount_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDiscountListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
