<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDestinationPrefixListResponse StructType
 * @subpackage Structs
 */
class GetDestinationPrefixListResponse extends AbstractStructBase
{
    /**
     * The destination_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:DestinationPrefixInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\DestinationPrefixInfo[]
     */
    public $destination_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetDestinationPrefixListResponse
     * @uses GetDestinationPrefixListResponse::setDestination_list()
     * @uses GetDestinationPrefixListResponse::setTotal()
     * @param \StructType\DestinationPrefixInfo[] $destination_list
     * @param int $total
     */
    public function __construct(array $destination_list = array(), $total = null)
    {
        $this
            ->setDestination_list($destination_list)
            ->setTotal($total);
    }
    /**
     * Get destination_list value
     * @return \StructType\DestinationPrefixInfo[]|null
     */
    public function getDestination_list()
    {
        return $this->destination_list;
    }
    /**
     * Set destination_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DestinationPrefixInfo[] $destination_list
     * @return \StructType\GetDestinationPrefixListResponse
     */
    public function setDestination_list(array $destination_list = array())
    {
        foreach ($destination_list as $getDestinationPrefixListResponseDestination_listItem) {
            // validation for constraint: itemType
            if (!$getDestinationPrefixListResponseDestination_listItem instanceof \StructType\DestinationPrefixInfo) {
                throw new \InvalidArgumentException(sprintf('The destination_list property can only contain items of \StructType\DestinationPrefixInfo, "%s" given', is_object($getDestinationPrefixListResponseDestination_listItem) ? get_class($getDestinationPrefixListResponseDestination_listItem) : gettype($getDestinationPrefixListResponseDestination_listItem)), __LINE__);
            }
        }
        $this->destination_list = $destination_list;
        return $this;
    }
    /**
     * Add item to destination_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DestinationPrefixInfo $item
     * @return \StructType\GetDestinationPrefixListResponse
     */
    public function addToDestination_list(\StructType\DestinationPrefixInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DestinationPrefixInfo) {
            throw new \InvalidArgumentException(sprintf('The destination_list property can only contain items of \StructType\DestinationPrefixInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->destination_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetDestinationPrefixListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDestinationPrefixListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
