<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDestinationInfoResponse StructType
 * @subpackage Structs
 */
class GetDestinationInfoResponse extends AbstractStructBase
{
    /**
     * The error_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $error_code;
    /**
     * The error_description
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $error_description;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The operator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $operator;
    /**
     * The operator_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $operator_id;
    /**
     * The input_currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $input_currency;
    /**
     * The output_currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $output_currency;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * The price_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:PriceListInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\PriceListInfo[]
     */
    public $price_list;
    /**
     * Constructor method for GetDestinationInfoResponse
     * @uses GetDestinationInfoResponse::setError_code()
     * @uses GetDestinationInfoResponse::setError_description()
     * @uses GetDestinationInfoResponse::setCountry()
     * @uses GetDestinationInfoResponse::setOperator()
     * @uses GetDestinationInfoResponse::setOperator_id()
     * @uses GetDestinationInfoResponse::setInput_currency()
     * @uses GetDestinationInfoResponse::setOutput_currency()
     * @uses GetDestinationInfoResponse::setDestination()
     * @uses GetDestinationInfoResponse::setPrice_list()
     * @param int $error_code
     * @param string $error_description
     * @param string $country
     * @param string $operator
     * @param int $operator_id
     * @param string $input_currency
     * @param string $output_currency
     * @param string $destination
     * @param \StructType\PriceListInfo[] $price_list
     */
    public function __construct($error_code = null, $error_description = null, $country = null, $operator = null, $operator_id = null, $input_currency = null, $output_currency = null, $destination = null, array $price_list = array())
    {
        $this
            ->setError_code($error_code)
            ->setError_description($error_description)
            ->setCountry($country)
            ->setOperator($operator)
            ->setOperator_id($operator_id)
            ->setInput_currency($input_currency)
            ->setOutput_currency($output_currency)
            ->setDestination($destination)
            ->setPrice_list($price_list);
    }
    /**
     * Get error_code value
     * @return int
     */
    public function getError_code()
    {
        return $this->error_code;
    }
    /**
     * Set error_code value
     * @param int $error_code
     * @return \StructType\GetDestinationInfoResponse
     */
    public function setError_code($error_code = null)
    {
        // validation for constraint: int
        if (!is_null($error_code) && !is_numeric($error_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($error_code)), __LINE__);
        }
        $this->error_code = $error_code;
        return $this;
    }
    /**
     * Get error_description value
     * @return string
     */
    public function getError_description()
    {
        return $this->error_description;
    }
    /**
     * Set error_description value
     * @param string $error_description
     * @return \StructType\GetDestinationInfoResponse
     */
    public function setError_description($error_description = null)
    {
        // validation for constraint: string
        if (!is_null($error_description) && !is_string($error_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($error_description)), __LINE__);
        }
        $this->error_description = $error_description;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\GetDestinationInfoResponse
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @param string $operator
     * @return \StructType\GetDestinationInfoResponse
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: string
        if (!is_null($operator) && !is_string($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operator)), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Get operator_id value
     * @return int|null
     */
    public function getOperator_id()
    {
        return $this->operator_id;
    }
    /**
     * Set operator_id value
     * @param int $operator_id
     * @return \StructType\GetDestinationInfoResponse
     */
    public function setOperator_id($operator_id = null)
    {
        // validation for constraint: int
        if (!is_null($operator_id) && !is_numeric($operator_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($operator_id)), __LINE__);
        }
        $this->operator_id = $operator_id;
        return $this;
    }
    /**
     * Get input_currency value
     * @return string|null
     */
    public function getInput_currency()
    {
        return $this->input_currency;
    }
    /**
     * Set input_currency value
     * @param string $input_currency
     * @return \StructType\GetDestinationInfoResponse
     */
    public function setInput_currency($input_currency = null)
    {
        // validation for constraint: string
        if (!is_null($input_currency) && !is_string($input_currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($input_currency)), __LINE__);
        }
        $this->input_currency = $input_currency;
        return $this;
    }
    /**
     * Get output_currency value
     * @return string|null
     */
    public function getOutput_currency()
    {
        return $this->output_currency;
    }
    /**
     * Set output_currency value
     * @param string $output_currency
     * @return \StructType\GetDestinationInfoResponse
     */
    public function setOutput_currency($output_currency = null)
    {
        // validation for constraint: string
        if (!is_null($output_currency) && !is_string($output_currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($output_currency)), __LINE__);
        }
        $this->output_currency = $output_currency;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\GetDestinationInfoResponse
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get price_list value
     * @return \StructType\PriceListInfo[]|null
     */
    public function getPrice_list()
    {
        return $this->price_list;
    }
    /**
     * Set price_list value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceListInfo[] $price_list
     * @return \StructType\GetDestinationInfoResponse
     */
    public function setPrice_list(array $price_list = array())
    {
        foreach ($price_list as $getDestinationInfoResponsePrice_listItem) {
            // validation for constraint: itemType
            if (!$getDestinationInfoResponsePrice_listItem instanceof \StructType\PriceListInfo) {
                throw new \InvalidArgumentException(sprintf('The price_list property can only contain items of \StructType\PriceListInfo, "%s" given', is_object($getDestinationInfoResponsePrice_listItem) ? get_class($getDestinationInfoResponsePrice_listItem) : gettype($getDestinationInfoResponsePrice_listItem)), __LINE__);
            }
        }
        $this->price_list = $price_list;
        return $this;
    }
    /**
     * Add item to price_list value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceListInfo $item
     * @return \StructType\GetDestinationInfoResponse
     */
    public function addToPrice_list(\StructType\PriceListInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PriceListInfo) {
            throw new \InvalidArgumentException(sprintf('The price_list property can only contain items of \StructType\PriceListInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->price_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDestinationInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
