<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDIDNumbersListResponse StructType
 * @subpackage Structs
 */
class GetDIDNumbersListResponse extends AbstractStructBase
{
    /**
     * The numbers_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:DIDNumberListInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\DIDNumberListInfo[]
     */
    public $numbers_list;
    /**
     * Constructor method for GetDIDNumbersListResponse
     * @uses GetDIDNumbersListResponse::setNumbers_list()
     * @param \StructType\DIDNumberListInfo[] $numbers_list
     */
    public function __construct(array $numbers_list = array())
    {
        $this
            ->setNumbers_list($numbers_list);
    }
    /**
     * Get numbers_list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DIDNumberListInfo[]|null
     */
    public function getNumbers_list()
    {
        return isset($this->numbers_list) ? $this->numbers_list : null;
    }
    /**
     * Set numbers_list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DIDNumberListInfo[] $numbers_list
     * @return \StructType\GetDIDNumbersListResponse
     */
    public function setNumbers_list(array $numbers_list = array())
    {
        foreach ($numbers_list as $getDIDNumbersListResponseNumbers_listItem) {
            // validation for constraint: itemType
            if (!$getDIDNumbersListResponseNumbers_listItem instanceof \StructType\DIDNumberListInfo) {
                throw new \InvalidArgumentException(sprintf('The numbers_list property can only contain items of \StructType\DIDNumberListInfo, "%s" given', is_object($getDIDNumbersListResponseNumbers_listItem) ? get_class($getDIDNumbersListResponseNumbers_listItem) : gettype($getDIDNumbersListResponseNumbers_listItem)), __LINE__);
            }
        }
        if (is_null($numbers_list) || (is_array($numbers_list) && empty($numbers_list))) {
            unset($this->numbers_list);
        } else {
            $this->numbers_list = $numbers_list;
        }
        return $this;
    }
    /**
     * Add item to numbers_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DIDNumberListInfo $item
     * @return \StructType\GetDIDNumbersListResponse
     */
    public function addToNumbers_list(\StructType\DIDNumberListInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DIDNumberListInfo) {
            throw new \InvalidArgumentException(sprintf('The numbers_list property can only contain items of \StructType\DIDNumberListInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->numbers_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDIDNumbersListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
