<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDIDNumberListResponse StructType
 * @subpackage Structs
 */
class GetDIDNumberListResponse extends AbstractStructBase
{
    /**
     * The number_list
     * Meta informations extracted from the WSDL
     * - arrayType: pst:DIDNumberInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\DIDNumberInfo[]
     */
    public $number_list;
    /**
     * Constructor method for GetDIDNumberListResponse
     * @uses GetDIDNumberListResponse::setNumber_list()
     * @param \StructType\DIDNumberInfo[] $number_list
     */
    public function __construct(array $number_list = array())
    {
        $this
            ->setNumber_list($number_list);
    }
    /**
     * Get number_list value
     * @return \StructType\DIDNumberInfo[]|null
     */
    public function getNumber_list()
    {
        return $this->number_list;
    }
    /**
     * Set number_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DIDNumberInfo[] $number_list
     * @return \StructType\GetDIDNumberListResponse
     */
    public function setNumber_list(array $number_list = array())
    {
        foreach ($number_list as $getDIDNumberListResponseNumber_listItem) {
            // validation for constraint: itemType
            if (!$getDIDNumberListResponseNumber_listItem instanceof \StructType\DIDNumberInfo) {
                throw new \InvalidArgumentException(sprintf('The number_list property can only contain items of \StructType\DIDNumberInfo, "%s" given', is_object($getDIDNumberListResponseNumber_listItem) ? get_class($getDIDNumberListResponseNumber_listItem) : gettype($getDIDNumberListResponseNumber_listItem)), __LINE__);
            }
        }
        $this->number_list = $number_list;
        return $this;
    }
    /**
     * Add item to number_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DIDNumberInfo $item
     * @return \StructType\GetDIDNumberListResponse
     */
    public function addToNumber_list(\StructType\DIDNumberInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DIDNumberInfo) {
            throw new \InvalidArgumentException(sprintf('The number_list property can only contain items of \StructType\DIDNumberInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->number_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDIDNumberListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
