<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDIDAreasListResponse StructType
 * @subpackage Structs
 */
class GetDIDAreasListResponse extends AbstractStructBase
{
    /**
     * The areas_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:DIDAreaInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\DIDAreaInfo[]
     */
    public $areas_list;
    /**
     * Constructor method for GetDIDAreasListResponse
     * @uses GetDIDAreasListResponse::setAreas_list()
     * @param \StructType\DIDAreaInfo[] $areas_list
     */
    public function __construct(array $areas_list = array())
    {
        $this
            ->setAreas_list($areas_list);
    }
    /**
     * Get areas_list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DIDAreaInfo[]|null
     */
    public function getAreas_list()
    {
        return isset($this->areas_list) ? $this->areas_list : null;
    }
    /**
     * Set areas_list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DIDAreaInfo[] $areas_list
     * @return \StructType\GetDIDAreasListResponse
     */
    public function setAreas_list(array $areas_list = array())
    {
        foreach ($areas_list as $getDIDAreasListResponseAreas_listItem) {
            // validation for constraint: itemType
            if (!$getDIDAreasListResponseAreas_listItem instanceof \StructType\DIDAreaInfo) {
                throw new \InvalidArgumentException(sprintf('The areas_list property can only contain items of \StructType\DIDAreaInfo, "%s" given', is_object($getDIDAreasListResponseAreas_listItem) ? get_class($getDIDAreasListResponseAreas_listItem) : gettype($getDIDAreasListResponseAreas_listItem)), __LINE__);
            }
        }
        if (is_null($areas_list) || (is_array($areas_list) && empty($areas_list))) {
            unset($this->areas_list);
        } else {
            $this->areas_list = $areas_list;
        }
        return $this;
    }
    /**
     * Add item to areas_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DIDAreaInfo $item
     * @return \StructType\GetDIDAreasListResponse
     */
    public function addToAreas_list(\StructType\DIDAreaInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DIDAreaInfo) {
            throw new \InvalidArgumentException(sprintf('The areas_list property can only contain items of \StructType\DIDAreaInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->areas_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDIDAreasListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
