<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerListResponse StructType
 * @subpackage Structs
 */
class GetCustomerListResponse extends AbstractStructBase
{
    /**
     * The customer_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:CustomerInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CustomerInfo[]
     */
    public $customer_list;
    /**
     * Constructor method for GetCustomerListResponse
     * @uses GetCustomerListResponse::setCustomer_list()
     * @param \StructType\CustomerInfo[] $customer_list
     */
    public function __construct(array $customer_list = array())
    {
        $this
            ->setCustomer_list($customer_list);
    }
    /**
     * Get customer_list value
     * @return \StructType\CustomerInfo[]|null
     */
    public function getCustomer_list()
    {
        return $this->customer_list;
    }
    /**
     * Set customer_list value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerInfo[] $customer_list
     * @return \StructType\GetCustomerListResponse
     */
    public function setCustomer_list(array $customer_list = array())
    {
        foreach ($customer_list as $getCustomerListResponseCustomer_listItem) {
            // validation for constraint: itemType
            if (!$getCustomerListResponseCustomer_listItem instanceof \StructType\CustomerInfo) {
                throw new \InvalidArgumentException(sprintf('The customer_list property can only contain items of \StructType\CustomerInfo, "%s" given', is_object($getCustomerListResponseCustomer_listItem) ? get_class($getCustomerListResponseCustomer_listItem) : gettype($getCustomerListResponseCustomer_listItem)), __LINE__);
            }
        }
        $this->customer_list = $customer_list;
        return $this;
    }
    /**
     * Add item to customer_list value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerInfo $item
     * @return \StructType\GetCustomerListResponse
     */
    public function addToCustomer_list(\StructType\CustomerInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerInfo) {
            throw new \InvalidArgumentException(sprintf('The customer_list property can only contain items of \StructType\CustomerInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customer_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
