<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerAbbreviatedDialingNumberListResponse StructType
 * @subpackage Structs
 */
class GetCustomerAbbreviatedDialingNumberListResponse extends AbstractStructBase
{
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $total;
    /**
     * The abbreviated_dialing_number_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:AbbreviatedDialingNumberInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\AbbreviatedDialingNumberInfo[]
     */
    public $abbreviated_dialing_number_list;
    /**
     * Constructor method for GetCustomerAbbreviatedDialingNumberListResponse
     * @uses GetCustomerAbbreviatedDialingNumberListResponse::setTotal()
     * @uses GetCustomerAbbreviatedDialingNumberListResponse::setAbbreviated_dialing_number_list()
     * @param int $total
     * @param \StructType\AbbreviatedDialingNumberInfo[] $abbreviated_dialing_number_list
     */
    public function __construct($total = null, array $abbreviated_dialing_number_list = array())
    {
        $this
            ->setTotal($total)
            ->setAbbreviated_dialing_number_list($abbreviated_dialing_number_list);
    }
    /**
     * Get total value
     * @return int
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetCustomerAbbreviatedDialingNumberListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get abbreviated_dialing_number_list value
     * @return \StructType\AbbreviatedDialingNumberInfo[]|null
     */
    public function getAbbreviated_dialing_number_list()
    {
        return $this->abbreviated_dialing_number_list;
    }
    /**
     * Set abbreviated_dialing_number_list value
     * @throws \InvalidArgumentException
     * @param \StructType\AbbreviatedDialingNumberInfo[] $abbreviated_dialing_number_list
     * @return \StructType\GetCustomerAbbreviatedDialingNumberListResponse
     */
    public function setAbbreviated_dialing_number_list(array $abbreviated_dialing_number_list = array())
    {
        foreach ($abbreviated_dialing_number_list as $getCustomerAbbreviatedDialingNumberListResponseAbbreviated_dialing_number_listItem) {
            // validation for constraint: itemType
            if (!$getCustomerAbbreviatedDialingNumberListResponseAbbreviated_dialing_number_listItem instanceof \StructType\AbbreviatedDialingNumberInfo) {
                throw new \InvalidArgumentException(sprintf('The abbreviated_dialing_number_list property can only contain items of \StructType\AbbreviatedDialingNumberInfo, "%s" given', is_object($getCustomerAbbreviatedDialingNumberListResponseAbbreviated_dialing_number_listItem) ? get_class($getCustomerAbbreviatedDialingNumberListResponseAbbreviated_dialing_number_listItem) : gettype($getCustomerAbbreviatedDialingNumberListResponseAbbreviated_dialing_number_listItem)), __LINE__);
            }
        }
        $this->abbreviated_dialing_number_list = $abbreviated_dialing_number_list;
        return $this;
    }
    /**
     * Add item to abbreviated_dialing_number_list value
     * @throws \InvalidArgumentException
     * @param \StructType\AbbreviatedDialingNumberInfo $item
     * @return \StructType\GetCustomerAbbreviatedDialingNumberListResponse
     */
    public function addToAbbreviated_dialing_number_list(\StructType\AbbreviatedDialingNumberInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AbbreviatedDialingNumberInfo) {
            throw new \InvalidArgumentException(sprintf('The abbreviated_dialing_number_list property can only contain items of \StructType\AbbreviatedDialingNumberInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->abbreviated_dialing_number_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerAbbreviatedDialingNumberListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
