<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCallBarringOptionsResponse StructType
 * @subpackage Structs
 */
class GetCallBarringOptionsResponse extends AbstractStructBase
{
    /**
     * The options
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:CallBarringRuleInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CallBarringRuleInfo[]
     */
    public $options;
    /**
     * Constructor method for GetCallBarringOptionsResponse
     * @uses GetCallBarringOptionsResponse::setOptions()
     * @param \StructType\CallBarringRuleInfo[] $options
     */
    public function __construct(array $options = array())
    {
        $this
            ->setOptions($options);
    }
    /**
     * Get options value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CallBarringRuleInfo[]|null
     */
    public function getOptions()
    {
        return isset($this->options) ? $this->options : null;
    }
    /**
     * Set options value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CallBarringRuleInfo[] $options
     * @return \StructType\GetCallBarringOptionsResponse
     */
    public function setOptions(array $options = array())
    {
        foreach ($options as $getCallBarringOptionsResponseOptionsItem) {
            // validation for constraint: itemType
            if (!$getCallBarringOptionsResponseOptionsItem instanceof \StructType\CallBarringRuleInfo) {
                throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\CallBarringRuleInfo, "%s" given', is_object($getCallBarringOptionsResponseOptionsItem) ? get_class($getCallBarringOptionsResponseOptionsItem) : gettype($getCallBarringOptionsResponseOptionsItem)), __LINE__);
            }
        }
        if (is_null($options) || (is_array($options) && empty($options))) {
            unset($this->options);
        } else {
            $this->options = $options;
        }
        return $this;
    }
    /**
     * Add item to options value
     * @throws \InvalidArgumentException
     * @param \StructType\CallBarringRuleInfo $item
     * @return \StructType\GetCallBarringOptionsResponse
     */
    public function addToOptions(\StructType\CallBarringRuleInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CallBarringRuleInfo) {
            throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\CallBarringRuleInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->options[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCallBarringOptionsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
