<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAuthzRuleListResponse StructType
 * @subpackage Structs
 */
class GetAuthzRuleListResponse extends AbstractStructBase
{
    /**
     * The authz_rule_list
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - arrayType: pst:AuthzRuleInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\AuthzRuleInfo[]
     */
    public $authz_rule_list;
    /**
     * Constructor method for GetAuthzRuleListResponse
     * @uses GetAuthzRuleListResponse::setAuthz_rule_list()
     * @param \StructType\AuthzRuleInfo[] $authz_rule_list
     */
    public function __construct(array $authz_rule_list = array())
    {
        $this
            ->setAuthz_rule_list($authz_rule_list);
    }
    /**
     * Get authz_rule_list value
     * @return \StructType\AuthzRuleInfo[]
     */
    public function getAuthz_rule_list()
    {
        return $this->authz_rule_list;
    }
    /**
     * Set authz_rule_list value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthzRuleInfo[] $authz_rule_list
     * @return \StructType\GetAuthzRuleListResponse
     */
    public function setAuthz_rule_list(array $authz_rule_list = array())
    {
        foreach ($authz_rule_list as $getAuthzRuleListResponseAuthz_rule_listItem) {
            // validation for constraint: itemType
            if (!$getAuthzRuleListResponseAuthz_rule_listItem instanceof \StructType\AuthzRuleInfo) {
                throw new \InvalidArgumentException(sprintf('The authz_rule_list property can only contain items of \StructType\AuthzRuleInfo, "%s" given', is_object($getAuthzRuleListResponseAuthz_rule_listItem) ? get_class($getAuthzRuleListResponseAuthz_rule_listItem) : gettype($getAuthzRuleListResponseAuthz_rule_listItem)), __LINE__);
            }
        }
        $this->authz_rule_list = $authz_rule_list;
        return $this;
    }
    /**
     * Add item to authz_rule_list value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthzRuleInfo $item
     * @return \StructType\GetAuthzRuleListResponse
     */
    public function addToAuthz_rule_list(\StructType\AuthzRuleInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AuthzRuleInfo) {
            throw new \InvalidArgumentException(sprintf('The authz_rule_list property can only contain items of \StructType\AuthzRuleInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->authz_rule_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAuthzRuleListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
