<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountXDRListRequest StructType
 * @subpackage Structs
 */
class GetAccountXDRListRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_account;
    /**
     * The from_date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $from_date;
    /**
     * The to_date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $to_date;
    /**
     * The i_service
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_service;
    /**
     * The i_service_type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_service_type;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $offset;
    /**
     * The format
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $format;
    /**
     * The get_total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $get_total;
    /**
     * The show_unsuccessful
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $show_unsuccessful;
    /**
     * Constructor method for GetAccountXDRListRequest
     * @uses GetAccountXDRListRequest::setI_account()
     * @uses GetAccountXDRListRequest::setFrom_date()
     * @uses GetAccountXDRListRequest::setTo_date()
     * @uses GetAccountXDRListRequest::setI_service()
     * @uses GetAccountXDRListRequest::setI_service_type()
     * @uses GetAccountXDRListRequest::setLimit()
     * @uses GetAccountXDRListRequest::setOffset()
     * @uses GetAccountXDRListRequest::setFormat()
     * @uses GetAccountXDRListRequest::setGet_total()
     * @uses GetAccountXDRListRequest::setShow_unsuccessful()
     * @param int $i_account
     * @param string $from_date
     * @param string $to_date
     * @param int $i_service
     * @param int $i_service_type
     * @param int $limit
     * @param int $offset
     * @param string $format
     * @param int $get_total
     * @param int $show_unsuccessful
     */
    public function __construct($i_account = null, $from_date = null, $to_date = null, $i_service = null, $i_service_type = null, $limit = null, $offset = null, $format = null, $get_total = null, $show_unsuccessful = null)
    {
        $this
            ->setI_account($i_account)
            ->setFrom_date($from_date)
            ->setTo_date($to_date)
            ->setI_service($i_service)
            ->setI_service_type($i_service_type)
            ->setLimit($limit)
            ->setOffset($offset)
            ->setFormat($format)
            ->setGet_total($get_total)
            ->setShow_unsuccessful($show_unsuccessful);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\GetAccountXDRListRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get from_date value
     * @return string
     */
    public function getFrom_date()
    {
        return $this->from_date;
    }
    /**
     * Set from_date value
     * @param string $from_date
     * @return \StructType\GetAccountXDRListRequest
     */
    public function setFrom_date($from_date = null)
    {
        // validation for constraint: string
        if (!is_null($from_date) && !is_string($from_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from_date)), __LINE__);
        }
        $this->from_date = $from_date;
        return $this;
    }
    /**
     * Get to_date value
     * @return string
     */
    public function getTo_date()
    {
        return $this->to_date;
    }
    /**
     * Set to_date value
     * @param string $to_date
     * @return \StructType\GetAccountXDRListRequest
     */
    public function setTo_date($to_date = null)
    {
        // validation for constraint: string
        if (!is_null($to_date) && !is_string($to_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to_date)), __LINE__);
        }
        $this->to_date = $to_date;
        return $this;
    }
    /**
     * Get i_service value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_service()
    {
        return isset($this->i_service) ? $this->i_service : null;
    }
    /**
     * Set i_service value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_service
     * @return \StructType\GetAccountXDRListRequest
     */
    public function setI_service($i_service = null)
    {
        // validation for constraint: int
        if (!is_null($i_service) && !is_numeric($i_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service)), __LINE__);
        }
        if (is_null($i_service) || (is_array($i_service) && empty($i_service))) {
            unset($this->i_service);
        } else {
            $this->i_service = $i_service;
        }
        return $this;
    }
    /**
     * Get i_service_type value
     * @return int|null
     */
    public function getI_service_type()
    {
        return $this->i_service_type;
    }
    /**
     * Set i_service_type value
     * @param int $i_service_type
     * @return \StructType\GetAccountXDRListRequest
     */
    public function setI_service_type($i_service_type = null)
    {
        // validation for constraint: int
        if (!is_null($i_service_type) && !is_numeric($i_service_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service_type)), __LINE__);
        }
        $this->i_service_type = $i_service_type;
        return $this;
    }
    /**
     * Get limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLimit()
    {
        return isset($this->limit) ? $this->limit : null;
    }
    /**
     * Set limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $limit
     * @return \StructType\GetAccountXDRListRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        if (is_null($limit) || (is_array($limit) && empty($limit))) {
            unset($this->limit);
        } else {
            $this->limit = $limit;
        }
        return $this;
    }
    /**
     * Get offset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOffset()
    {
        return isset($this->offset) ? $this->offset : null;
    }
    /**
     * Set offset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $offset
     * @return \StructType\GetAccountXDRListRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        if (is_null($offset) || (is_array($offset) && empty($offset))) {
            unset($this->offset);
        } else {
            $this->offset = $offset;
        }
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \StructType\GetAccountXDRListRequest
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get get_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGet_total()
    {
        return isset($this->get_total) ? $this->get_total : null;
    }
    /**
     * Set get_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $get_total
     * @return \StructType\GetAccountXDRListRequest
     */
    public function setGet_total($get_total = null)
    {
        // validation for constraint: int
        if (!is_null($get_total) && !is_numeric($get_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($get_total)), __LINE__);
        }
        if (is_null($get_total) || (is_array($get_total) && empty($get_total))) {
            unset($this->get_total);
        } else {
            $this->get_total = $get_total;
        }
        return $this;
    }
    /**
     * Get show_unsuccessful value
     * @return int|null
     */
    public function getShow_unsuccessful()
    {
        return $this->show_unsuccessful;
    }
    /**
     * Set show_unsuccessful value
     * @param int $show_unsuccessful
     * @return \StructType\GetAccountXDRListRequest
     */
    public function setShow_unsuccessful($show_unsuccessful = null)
    {
        // validation for constraint: int
        if (!is_null($show_unsuccessful) && !is_numeric($show_unsuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($show_unsuccessful)), __LINE__);
        }
        $this->show_unsuccessful = $show_unsuccessful;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountXDRListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
