<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountStateRequest StructType
 * @subpackage Structs
 */
class GetAccountStateRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The i_acc_state_type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_acc_state_type;
    /**
     * The state_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state_name;
    /**
     * The service_type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $service_type;
    /**
     * Constructor method for GetAccountStateRequest
     * @uses GetAccountStateRequest::setI_account()
     * @uses GetAccountStateRequest::setI_acc_state_type()
     * @uses GetAccountStateRequest::setState_name()
     * @uses GetAccountStateRequest::setService_type()
     * @param int $i_account
     * @param int $i_acc_state_type
     * @param string $state_name
     * @param string $service_type
     */
    public function __construct($i_account = null, $i_acc_state_type = null, $state_name = null, $service_type = null)
    {
        $this
            ->setI_account($i_account)
            ->setI_acc_state_type($i_acc_state_type)
            ->setState_name($state_name)
            ->setService_type($service_type);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\GetAccountStateRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get i_acc_state_type value
     * @return int|null
     */
    public function getI_acc_state_type()
    {
        return $this->i_acc_state_type;
    }
    /**
     * Set i_acc_state_type value
     * @param int $i_acc_state_type
     * @return \StructType\GetAccountStateRequest
     */
    public function setI_acc_state_type($i_acc_state_type = null)
    {
        // validation for constraint: int
        if (!is_null($i_acc_state_type) && !is_numeric($i_acc_state_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_acc_state_type)), __LINE__);
        }
        $this->i_acc_state_type = $i_acc_state_type;
        return $this;
    }
    /**
     * Get state_name value
     * @return string|null
     */
    public function getState_name()
    {
        return $this->state_name;
    }
    /**
     * Set state_name value
     * @param string $state_name
     * @return \StructType\GetAccountStateRequest
     */
    public function setState_name($state_name = null)
    {
        // validation for constraint: string
        if (!is_null($state_name) && !is_string($state_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state_name)), __LINE__);
        }
        $this->state_name = $state_name;
        return $this;
    }
    /**
     * Get service_type value
     * @return string|null
     */
    public function getService_type()
    {
        return $this->service_type;
    }
    /**
     * Set service_type value
     * @param string $service_type
     * @return \StructType\GetAccountStateRequest
     */
    public function setService_type($service_type = null)
    {
        // validation for constraint: string
        if (!is_null($service_type) && !is_string($service_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($service_type)), __LINE__);
        }
        $this->service_type = $service_type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountStateRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
