<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountAliasListRequest StructType
 * @subpackage Structs
 */
class GetAccountAliasListRequest extends AbstractStructBase
{
    /**
     * The i_master_account
     * @var int
     */
    public $i_master_account;
    /**
     * The get_total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $get_total;
    /**
     * Constructor method for GetAccountAliasListRequest
     * @uses GetAccountAliasListRequest::setI_master_account()
     * @uses GetAccountAliasListRequest::setGet_total()
     * @param int $i_master_account
     * @param int $get_total
     */
    public function __construct($i_master_account = null, $get_total = null)
    {
        $this
            ->setI_master_account($i_master_account)
            ->setGet_total($get_total);
    }
    /**
     * Get i_master_account value
     * @return int|null
     */
    public function getI_master_account()
    {
        return $this->i_master_account;
    }
    /**
     * Set i_master_account value
     * @param int $i_master_account
     * @return \StructType\GetAccountAliasListRequest
     */
    public function setI_master_account($i_master_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_master_account) && !is_numeric($i_master_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_master_account)), __LINE__);
        }
        $this->i_master_account = $i_master_account;
        return $this;
    }
    /**
     * Get get_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGet_total()
    {
        return isset($this->get_total) ? $this->get_total : null;
    }
    /**
     * Set get_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $get_total
     * @return \StructType\GetAccountAliasListRequest
     */
    public function setGet_total($get_total = null)
    {
        // validation for constraint: int
        if (!is_null($get_total) && !is_numeric($get_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($get_total)), __LINE__);
        }
        if (is_null($get_total) || (is_array($get_total) && empty($get_total))) {
            unset($this->get_total);
        } else {
            $this->get_total = $get_total;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountAliasListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
