<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateUaProfileResponse StructType
 * @subpackage Structs
 */
class GenerateUaProfileResponse extends AbstractStructBase
{
    /**
     * The remote_url
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $remote_url;
    /**
     * The filename
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $filename;
    /**
     * The profile_string_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $profile_string_list;
    /**
     * Constructor method for GenerateUaProfileResponse
     * @uses GenerateUaProfileResponse::setRemote_url()
     * @uses GenerateUaProfileResponse::setFilename()
     * @uses GenerateUaProfileResponse::setProfile_string_list()
     * @param string $remote_url
     * @param string $filename
     * @param string[] $profile_string_list
     */
    public function __construct($remote_url = null, $filename = null, array $profile_string_list = array())
    {
        $this
            ->setRemote_url($remote_url)
            ->setFilename($filename)
            ->setProfile_string_list($profile_string_list);
    }
    /**
     * Get remote_url value
     * @return string
     */
    public function getRemote_url()
    {
        return $this->remote_url;
    }
    /**
     * Set remote_url value
     * @param string $remote_url
     * @return \StructType\GenerateUaProfileResponse
     */
    public function setRemote_url($remote_url = null)
    {
        // validation for constraint: string
        if (!is_null($remote_url) && !is_string($remote_url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remote_url)), __LINE__);
        }
        $this->remote_url = $remote_url;
        return $this;
    }
    /**
     * Get filename value
     * @return string
     */
    public function getFilename()
    {
        return $this->filename;
    }
    /**
     * Set filename value
     * @param string $filename
     * @return \StructType\GenerateUaProfileResponse
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
    /**
     * Get profile_string_list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getProfile_string_list()
    {
        return isset($this->profile_string_list) ? $this->profile_string_list : null;
    }
    /**
     * Set profile_string_list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $profile_string_list
     * @return \StructType\GenerateUaProfileResponse
     */
    public function setProfile_string_list(array $profile_string_list = array())
    {
        foreach ($profile_string_list as $generateUaProfileResponseProfile_string_listItem) {
            // validation for constraint: itemType
            if (!is_string($generateUaProfileResponseProfile_string_listItem)) {
                throw new \InvalidArgumentException(sprintf('The profile_string_list property can only contain items of string, "%s" given', is_object($generateUaProfileResponseProfile_string_listItem) ? get_class($generateUaProfileResponseProfile_string_listItem) : gettype($generateUaProfileResponseProfile_string_listItem)), __LINE__);
            }
        }
        if (is_null($profile_string_list) || (is_array($profile_string_list) && empty($profile_string_list))) {
            unset($this->profile_string_list);
        } else {
            $this->profile_string_list = $profile_string_list;
        }
        return $this;
    }
    /**
     * Add item to profile_string_list value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GenerateUaProfileResponse
     */
    public function addToProfile_string_list($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The profile_string_list property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->profile_string_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenerateUaProfileResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
