<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateOutOfTurnInvoiceRequest StructType
 * @subpackage Structs
 */
class GenerateOutOfTurnInvoiceRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_customer;
    /**
     * The xdr_list
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - arrayType: pst:OutOfTurnXDRInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\OutOfTurnXDRInfo[]
     */
    public $xdr_list;
    /**
     * Constructor method for GenerateOutOfTurnInvoiceRequest
     * @uses GenerateOutOfTurnInvoiceRequest::setI_customer()
     * @uses GenerateOutOfTurnInvoiceRequest::setXdr_list()
     * @param int $i_customer
     * @param \StructType\OutOfTurnXDRInfo[] $xdr_list
     */
    public function __construct($i_customer = null, array $xdr_list = array())
    {
        $this
            ->setI_customer($i_customer)
            ->setXdr_list($xdr_list);
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\GenerateOutOfTurnInvoiceRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get xdr_list value
     * @return \StructType\OutOfTurnXDRInfo[]
     */
    public function getXdr_list()
    {
        return $this->xdr_list;
    }
    /**
     * Set xdr_list value
     * @throws \InvalidArgumentException
     * @param \StructType\OutOfTurnXDRInfo[] $xdr_list
     * @return \StructType\GenerateOutOfTurnInvoiceRequest
     */
    public function setXdr_list(array $xdr_list = array())
    {
        foreach ($xdr_list as $generateOutOfTurnInvoiceRequestXdr_listItem) {
            // validation for constraint: itemType
            if (!$generateOutOfTurnInvoiceRequestXdr_listItem instanceof \StructType\OutOfTurnXDRInfo) {
                throw new \InvalidArgumentException(sprintf('The xdr_list property can only contain items of \StructType\OutOfTurnXDRInfo, "%s" given', is_object($generateOutOfTurnInvoiceRequestXdr_listItem) ? get_class($generateOutOfTurnInvoiceRequestXdr_listItem) : gettype($generateOutOfTurnInvoiceRequestXdr_listItem)), __LINE__);
            }
        }
        $this->xdr_list = $xdr_list;
        return $this;
    }
    /**
     * Add item to xdr_list value
     * @throws \InvalidArgumentException
     * @param \StructType\OutOfTurnXDRInfo $item
     * @return \StructType\GenerateOutOfTurnInvoiceRequest
     */
    public function addToXdr_list(\StructType\OutOfTurnXDRInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OutOfTurnXDRInfo) {
            throw new \InvalidArgumentException(sprintf('The xdr_list property can only contain items of \StructType\OutOfTurnXDRInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->xdr_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenerateOutOfTurnInvoiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
