<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FollowMeNumberInfo StructType
 * @subpackage Structs
 */
class FollowMeNumberInfo extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_account;
    /**
     * The i_follow_me
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_follow_me;
    /**
     * The i_follow_me_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_follow_me_number;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The timeout
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $timeout;
    /**
     * The redirect_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $redirect_number;
    /**
     * The period
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $period;
    /**
     * The period_description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $period_description;
    /**
     * The active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $active;
    /**
     * The i_follow_order
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_follow_order;
    /**
     * The domain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $domain;
    /**
     * The keep_original_cld
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $keep_original_cld;
    /**
     * The keep_original_cli
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $keep_original_cli;
    /**
     * The use_tcp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $use_tcp;
    /**
     * The max_sim_calls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $max_sim_calls;
    /**
     * Constructor method for FollowMeNumberInfo
     * @uses FollowMeNumberInfo::setI_account()
     * @uses FollowMeNumberInfo::setI_follow_me()
     * @uses FollowMeNumberInfo::setI_follow_me_number()
     * @uses FollowMeNumberInfo::setName()
     * @uses FollowMeNumberInfo::setTimeout()
     * @uses FollowMeNumberInfo::setRedirect_number()
     * @uses FollowMeNumberInfo::setPeriod()
     * @uses FollowMeNumberInfo::setPeriod_description()
     * @uses FollowMeNumberInfo::setActive()
     * @uses FollowMeNumberInfo::setI_follow_order()
     * @uses FollowMeNumberInfo::setDomain()
     * @uses FollowMeNumberInfo::setKeep_original_cld()
     * @uses FollowMeNumberInfo::setKeep_original_cli()
     * @uses FollowMeNumberInfo::setUse_tcp()
     * @uses FollowMeNumberInfo::setMax_sim_calls()
     * @param int $i_account
     * @param int $i_follow_me
     * @param int $i_follow_me_number
     * @param string $name
     * @param int $timeout
     * @param string $redirect_number
     * @param string $period
     * @param string $period_description
     * @param string $active
     * @param int $i_follow_order
     * @param string $domain
     * @param string $keep_original_cld
     * @param string $keep_original_cli
     * @param string $use_tcp
     * @param int $max_sim_calls
     */
    public function __construct($i_account = null, $i_follow_me = null, $i_follow_me_number = null, $name = null, $timeout = null, $redirect_number = null, $period = null, $period_description = null, $active = null, $i_follow_order = null, $domain = null, $keep_original_cld = null, $keep_original_cli = null, $use_tcp = null, $max_sim_calls = null)
    {
        $this
            ->setI_account($i_account)
            ->setI_follow_me($i_follow_me)
            ->setI_follow_me_number($i_follow_me_number)
            ->setName($name)
            ->setTimeout($timeout)
            ->setRedirect_number($redirect_number)
            ->setPeriod($period)
            ->setPeriod_description($period_description)
            ->setActive($active)
            ->setI_follow_order($i_follow_order)
            ->setDomain($domain)
            ->setKeep_original_cld($keep_original_cld)
            ->setKeep_original_cli($keep_original_cli)
            ->setUse_tcp($use_tcp)
            ->setMax_sim_calls($max_sim_calls);
    }
    /**
     * Get i_account value
     * @return int|null
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\FollowMeNumberInfo
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get i_follow_me value
     * @return int|null
     */
    public function getI_follow_me()
    {
        return $this->i_follow_me;
    }
    /**
     * Set i_follow_me value
     * @param int $i_follow_me
     * @return \StructType\FollowMeNumberInfo
     */
    public function setI_follow_me($i_follow_me = null)
    {
        // validation for constraint: int
        if (!is_null($i_follow_me) && !is_numeric($i_follow_me)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_follow_me)), __LINE__);
        }
        $this->i_follow_me = $i_follow_me;
        return $this;
    }
    /**
     * Get i_follow_me_number value
     * @return int|null
     */
    public function getI_follow_me_number()
    {
        return $this->i_follow_me_number;
    }
    /**
     * Set i_follow_me_number value
     * @param int $i_follow_me_number
     * @return \StructType\FollowMeNumberInfo
     */
    public function setI_follow_me_number($i_follow_me_number = null)
    {
        // validation for constraint: int
        if (!is_null($i_follow_me_number) && !is_numeric($i_follow_me_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_follow_me_number)), __LINE__);
        }
        $this->i_follow_me_number = $i_follow_me_number;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\FollowMeNumberInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get timeout value
     * @return int|null
     */
    public function getTimeout()
    {
        return $this->timeout;
    }
    /**
     * Set timeout value
     * @param int $timeout
     * @return \StructType\FollowMeNumberInfo
     */
    public function setTimeout($timeout = null)
    {
        // validation for constraint: int
        if (!is_null($timeout) && !is_numeric($timeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timeout)), __LINE__);
        }
        $this->timeout = $timeout;
        return $this;
    }
    /**
     * Get redirect_number value
     * @return string|null
     */
    public function getRedirect_number()
    {
        return $this->redirect_number;
    }
    /**
     * Set redirect_number value
     * @param string $redirect_number
     * @return \StructType\FollowMeNumberInfo
     */
    public function setRedirect_number($redirect_number = null)
    {
        // validation for constraint: string
        if (!is_null($redirect_number) && !is_string($redirect_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirect_number)), __LINE__);
        }
        $this->redirect_number = $redirect_number;
        return $this;
    }
    /**
     * Get period value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriod()
    {
        return isset($this->period) ? $this->period : null;
    }
    /**
     * Set period value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $period
     * @return \StructType\FollowMeNumberInfo
     */
    public function setPeriod($period = null)
    {
        // validation for constraint: string
        if (!is_null($period) && !is_string($period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($period)), __LINE__);
        }
        if (is_null($period) || (is_array($period) && empty($period))) {
            unset($this->period);
        } else {
            $this->period = $period;
        }
        return $this;
    }
    /**
     * Get period_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriod_description()
    {
        return isset($this->period_description) ? $this->period_description : null;
    }
    /**
     * Set period_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $period_description
     * @return \StructType\FollowMeNumberInfo
     */
    public function setPeriod_description($period_description = null)
    {
        // validation for constraint: string
        if (!is_null($period_description) && !is_string($period_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($period_description)), __LINE__);
        }
        if (is_null($period_description) || (is_array($period_description) && empty($period_description))) {
            unset($this->period_description);
        } else {
            $this->period_description = $period_description;
        }
        return $this;
    }
    /**
     * Get active value
     * @return string|null
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param string $active
     * @return \StructType\FollowMeNumberInfo
     */
    public function setActive($active = null)
    {
        // validation for constraint: string
        if (!is_null($active) && !is_string($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get i_follow_order value
     * @return int|null
     */
    public function getI_follow_order()
    {
        return $this->i_follow_order;
    }
    /**
     * Set i_follow_order value
     * @param int $i_follow_order
     * @return \StructType\FollowMeNumberInfo
     */
    public function setI_follow_order($i_follow_order = null)
    {
        // validation for constraint: int
        if (!is_null($i_follow_order) && !is_numeric($i_follow_order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_follow_order)), __LINE__);
        }
        $this->i_follow_order = $i_follow_order;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\FollowMeNumberInfo
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get keep_original_cld value
     * @return string|null
     */
    public function getKeep_original_cld()
    {
        return $this->keep_original_cld;
    }
    /**
     * Set keep_original_cld value
     * @param string $keep_original_cld
     * @return \StructType\FollowMeNumberInfo
     */
    public function setKeep_original_cld($keep_original_cld = null)
    {
        // validation for constraint: string
        if (!is_null($keep_original_cld) && !is_string($keep_original_cld)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keep_original_cld)), __LINE__);
        }
        $this->keep_original_cld = $keep_original_cld;
        return $this;
    }
    /**
     * Get keep_original_cli value
     * @return string|null
     */
    public function getKeep_original_cli()
    {
        return $this->keep_original_cli;
    }
    /**
     * Set keep_original_cli value
     * @param string $keep_original_cli
     * @return \StructType\FollowMeNumberInfo
     */
    public function setKeep_original_cli($keep_original_cli = null)
    {
        // validation for constraint: string
        if (!is_null($keep_original_cli) && !is_string($keep_original_cli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keep_original_cli)), __LINE__);
        }
        $this->keep_original_cli = $keep_original_cli;
        return $this;
    }
    /**
     * Get use_tcp value
     * @return string|null
     */
    public function getUse_tcp()
    {
        return $this->use_tcp;
    }
    /**
     * Set use_tcp value
     * @param string $use_tcp
     * @return \StructType\FollowMeNumberInfo
     */
    public function setUse_tcp($use_tcp = null)
    {
        // validation for constraint: string
        if (!is_null($use_tcp) && !is_string($use_tcp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($use_tcp)), __LINE__);
        }
        $this->use_tcp = $use_tcp;
        return $this;
    }
    /**
     * Get max_sim_calls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMax_sim_calls()
    {
        return isset($this->max_sim_calls) ? $this->max_sim_calls : null;
    }
    /**
     * Set max_sim_calls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $max_sim_calls
     * @return \StructType\FollowMeNumberInfo
     */
    public function setMax_sim_calls($max_sim_calls = null)
    {
        // validation for constraint: int
        if (!is_null($max_sim_calls) && !is_numeric($max_sim_calls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($max_sim_calls)), __LINE__);
        }
        if (is_null($max_sim_calls) || (is_array($max_sim_calls) && empty($max_sim_calls))) {
            unset($this->max_sim_calls);
        } else {
            $this->max_sim_calls = $max_sim_calls;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FollowMeNumberInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
